<?php

namespace App\Filament\Resources\AssociationResource\Api\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateAssociationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required',
            'license_number' => 'required',
            'license_expiration_date' => 'required|date',
            'representative_full_name' => 'required',
            'representative_position' => 'required',
            'phone_number' => 'required',
            'secondary_phone_number' => 'required',
            'email' => 'required',
            'map_location' => 'required',
            'city' => 'required',
            'postal_code' => 'required',
            'neighborhood' => 'required',
            'building_number' => 'required',
            'street' => 'required',
            'branch_number' => 'required',
            'iban' => 'required',
            'bank_name' => 'required',
            'account_holder_name' => 'required',
            'is_verified' => 'required',
            'is_locked' => 'required',
            'lat' => 'required',
            'lng' => 'required',
        ];
    }
}
