<?php

namespace App\Filament\Resources\AssociationResource\Api\Handlers;

use App\Filament\Resources\AssociationResource;
use App\Filament\Resources\AssociationResource\Api\Requests\UpdateAssociationRequest;
use Rupadana\ApiService\Http\Handlers;

class UpdateHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = AssociationResource::class;

    public static function getMethod()
    {
        return Handlers::PUT;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Update Association
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(UpdateAssociationRequest $request)
    {
        $id = $request->route('id');

        $model = static::getModel()::find($id);

        if (! $model) {
            return static::sendNotFoundResponse();
        }

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Update Resource');
    }
}
