<?php

namespace App\Filament\Resources\AssociationResource\Api\Handlers;

use App\Filament\Resources\AssociationResource;
use App\Filament\Resources\AssociationResource\Api\Requests\CreateAssociationRequest;
use Rupadana\ApiService\Http\Handlers;

class CreateHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = AssociationResource::class;

    public static function getMethod()
    {
        return Handlers::POST;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Create Association
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(CreateAssociationRequest $request)
    {
        $model = new (static::getModel());

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Create Resource');
    }
}
