<?php

namespace App\Filament\Resources\AdminsTaskResource\Api\Handlers;

use App\Filament\Resources\AdminsTaskResource;
use App\Filament\Resources\AdminsTaskResource\Api\Requests\UpdateAdminsTaskRequest;
use Rupadana\ApiService\Http\Handlers;

class UpdateHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = AdminsTaskResource::class;

    public static function getMethod()
    {
        return Handlers::PUT;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Update AdminsTask
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(UpdateAdminsTaskRequest $request)
    {
        $id = $request->route('id');

        $model = static::getModel()::find($id);

        if (! $model) {
            return static::sendNotFoundResponse();
        }

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Update Resource');
    }
}
