<?php

namespace App\Filament\Resources\AdminsTaskResource\Api\Handlers;

use App\Filament\Resources\AdminsTaskResource;
use App\Filament\Resources\AdminsTaskResource\Api\Transformers\AdminsTaskTransformer;
use Illuminate\Http\Request;
use Rupadana\ApiService\Http\Handlers;
use Spatie\QueryBuilder\QueryBuilder;

class DetailHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = AdminsTaskResource::class;

    /**
     * Show AdminsTask
     *
     * @return AdminsTaskTransformer
     */
    public function handler(Request $request)
    {
        $id = $request->route('id');

        $query = static::getEloquentQuery();

        $query = QueryBuilder::for(
            $query->where(static::getKeyName(), $id)
        )
            ->first();

        if (! $query) {
            return static::sendNotFoundResponse();
        }

        return new AdminsTaskTransformer($query);
    }
}
