<?php

namespace App\Filament\Resources\AdminsTaskResource\Api\Handlers;

use App\Filament\Resources\AdminsTaskResource;
use App\Filament\Resources\AdminsTaskResource\Api\Requests\CreateAdminsTaskRequest;
use Rupadana\ApiService\Http\Handlers;

class CreateHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = AdminsTaskResource::class;

    public static function getMethod()
    {
        return Handlers::POST;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Create AdminsTask
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(CreateAdminsTaskRequest $request)
    {
        $model = new (static::getModel());

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Create Resource');
    }
}
