<?php

namespace App\Filament\Resources;

use App\Filament\Resources\AdminsTaskResource\Pages;
use App\Models\AdminsTask;
use BezhanSalleh\FilamentShield\Contracts\HasShieldPermissions;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Contracts\Support\Htmlable;

class AdminsTaskResource extends Resource implements HasShieldPermissions
{
    protected static ?string $model = AdminsTask::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function shouldRegisterNavigation(): bool
    {
        return false;
    }

    public static function getNavigationLabel(): string
    {
        return __('admins_task.admins_tasks');
    }

    public function getTitle(): string|Htmlable
    {
        return __('admins_task.admins_tasks');
    }

    public static function getModelLabel(): string
    {
        return __('admins_task.admins_task');
    }

    public static function getPluralModelLabel(): string
    {
        return __('admins_task.admins_tasks');
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label(__('admins_task.name'))
                    ->searchable()
                    ->sortable(),

                Tables\Columns\TextColumn::make('description')
                    ->label(__('admins_task.description'))
                    ->limit(20)
                    ->searchable(),

                Tables\Columns\TextColumn::make('start_date')
                    ->label(__('admins_task.start_date'))
                    ->date()
                    ->sortable(),

                Tables\Columns\TextColumn::make('end_date')
                    ->label(__('admins_task.end_date'))
                    ->date()
                    ->sortable(),

                Tables\Columns\TextColumn::make('created_at')
                    ->label(__('common.created_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->defaultSort('created_at', 'desc');
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListAdminsTasks::route('/'),
            'create' => Pages\CreateAdminsTask::route('/create'),
            'edit' => Pages\EditAdminsTask::route('/{record}/edit'),
        ];
    }

    public static function getPermissionPrefixes(): array
    {
        return [
            'view',
            'view_any',
            'create',
            'update',
            'restore',
            'restore_any',
            'replicate',
            'reorder',
            'delete',
            'delete_any',
            'force_delete',
            'force_delete_any',

            // View permissions
            'view_all',
        ];
    }
}
