<?php

namespace App\Filament\Pages;

use App\Filament\Widgets\AssociationsDashboardStatsOverview;
use App\Filament\Widgets\OrdersDashboardStatsOverview;
use App\Filament\Widgets\OrdersMap;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Form;
use Filament\Pages\Dashboard\Concerns\HasFiltersForm;

class OrdersDashboard extends \Filament\Pages\Dashboard
{
    use HasFiltersForm, HasPageShield;

    protected static string $routePath = 'orders_dashboard';

    public static function getNavigationLabel(): string
    {
        return __('pages.orders_dashboard');
    }

    public function getTitle(): string
    {
        return __('pages.orders_dashboard');
    }

    public static function getNavigationGroup(): ?string
    {
        return __('common.navigation.group.association_management');
    }

    // protected static ?int $navigationSort = 2;

    public function getWidgets(): array
    {
        return [
            OrdersDashboardStatsOverview::class,
            \App\Filament\Widgets\ClassificationOrdersStatsOverview::class,
            AssociationsDashboardStatsOverview::class,
            \App\Filament\Widgets\OrderStatusApexChart::class,
            \App\Filament\Widgets\ClassificationOrdersValuesPieChart::class,
            \App\Filament\Widgets\DonorFinancialPortfolioApexChart::class,
            \App\Filament\Widgets\OrderProductStatsTable::class,
            OrdersMap::class,
        ];
    }

    public function filtersForm(Form $form): Form
    {
        // Generate year options from 2020 to current year + 1
        $currentYear = now()->year;
        $years = [];
        for ($year = 2020; $year <= $currentYear + 1; $year++) {
            $years[$year] = $year;
        }

        return $form
            ->schema([
                Section::make(__('widgets.filters'))
                    ->schema([
                        Select::make('year')
                            ->label(__('widgets.year'))
                            ->placeholder(__('widgets.all_years'))
                            ->options($years)
                            ->searchable()
                            ->native(false),
                        Select::make('project_type')
                            ->label(__('widgets.project_type_filter'))
                            ->placeholder(__('widgets.all_project_types'))
                            ->options(\App\Models\Order::getOrderTypes())
                            ->searchable()
                            ->native(false),
                    ])
                    ->columns(2),
            ]);
    }
}
