<?php

namespace App\Filament\Pages;

use App\Filament\Widgets\DonorPortfolioStatsOverview;
use App\Filament\Widgets\DonorProjectStatusTable;
use App\Filament\Widgets\FinancialPortfoliosExpensesChart;
use App\Filament\Widgets\FinancialPortfoliosStatsOverview;
use App\Filament\Widgets\FinancialPortfoliosStatusTable;
use App\Filament\Widgets\FinancialPortfoliosSummaryByTagsTable;
use App\Filament\Widgets\FinancialPortfoliosValueChart;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;
use Filament\Pages\Dashboard\Concerns\HasFiltersForm;

class ImpactFinancialPortfoliosDashboard extends \Filament\Pages\Dashboard
{
    use HasFiltersForm, HasPageShield;

    protected static string $routePath = 'impact_financial_portfolios_dashboard';

    public static function getNavigationLabel(): string
    {
        return __('pages.impact_financial_portfolios_dashboard');
    }

    public function getTitle(): string
    {
        return __('pages.impact_financial_portfolios_dashboard');
    }

    public static function getNavigationGroup(): ?string
    {
        return __('common.navigation.group.donors');
    }

    // protected static ?int $navigationSort = 3;

    public function getWidgets(): array
    {
        return [
            FinancialPortfoliosStatsOverview::class,
            DonorPortfolioStatsOverview::class,
            FinancialPortfoliosValueChart::class,
            FinancialPortfoliosExpensesChart::class,
            FinancialPortfoliosStatusTable::class,
            DonorProjectStatusTable::class,
            FinancialPortfoliosSummaryByTagsTable::class,
        ];
    }
}
