<?php

namespace App\Filament\Exports;

use App\Models\WellLicense;
use Filament\Actions\Exports\ExportColumn;
use Filament\Actions\Exports\Exporter;
use Filament\Actions\Exports\Models\Export;

class WellLicenseExporter extends Exporter
{
    protected static ?string $model = WellLicense::class;

    public static function getColumns(): array
    {
        return [
            ExportColumn::make('id')
                ->label(__('well_license.id')),
            ExportColumn::make('well_name')
                ->label(__('well_license.well_name')),
            ExportColumn::make('association.name')
                ->label(__('well_license.association')),
            ExportColumn::make('status')
                ->label(__('well_license.status'))
                ->formatStateUsing(fn ($state): string => $state?->getLabel() ?? ''),
            ExportColumn::make('ministry_license_number')
                ->label(__('well_license.ministry_license_number')),
            ExportColumn::make('ministry_license_start_date')
                ->label(__('well_license.ministry_license_start_date')),
            ExportColumn::make('ministry_license_end_date')
                ->label(__('well_license.ministry_license_end_date')),
            ExportColumn::make('delegation_start_date')
                ->label(__('well_license.delegation_start_date')),
            ExportColumn::make('delegation_end_date')
                ->label(__('well_license.delegation_end_date')),
            ExportColumn::make('state.name')
                ->label(__('well_license.state')),
            ExportColumn::make('city.name')
                ->label(__('well_license.city')),
            ExportColumn::make('center.name')
                ->label(__('well_license.center')),
            ExportColumn::make('lat')
                ->label(__('well_license.lat')),
            ExportColumn::make('lng')
                ->label(__('well_license.lng')),
            ExportColumn::make('well_depth')
                ->label(__('well_license.well_depth')),
            ExportColumn::make('well_diameter')
                ->label(__('well_license.well_diameter')),
            ExportColumn::make('pump_size')
                ->label(__('well_license.pump_size')),
            ExportColumn::make('withdrawal_amount')
                ->label(__('well_license.withdrawal_amount')),
            ExportColumn::make('createdBy.name')
                ->label(__('well_license.created_by')),
            ExportColumn::make('created_at')
                ->label(__('well_license.created_at')),
            ExportColumn::make('updated_at')
                ->label(__('well_license.updated_at')),
        ];
    }

    public static function getCompletedNotificationBody(Export $export): string
    {
        $successfulRows = $export->successful_rows;
        $rowWord = $successfulRows === 1 ? __('well_license.row') : __('well_license.rows');

        $body = __('well_license.export_completed', [
            'count' => number_format($successfulRows),
            'rows' => $rowWord,
        ]);

        if ($failedRowsCount = $export->getFailedRowsCount()) {
            $failedRowWord = $failedRowsCount === 1 ? __('well_license.row') : __('well_license.rows');
            $body .= ' '.__('well_license.export_failed_rows', [
                'count' => number_format($failedRowsCount),
                'rows' => $failedRowWord,
            ]);
        }

        return $body;
    }
}
