<?php

namespace App\Filament\Exports;

use App\Models\StationLicense;
use Filament\Actions\Exports\ExportColumn;
use Filament\Actions\Exports\Exporter;
use Filament\Actions\Exports\Models\Export;

class StationLicenseExporter extends Exporter
{
    protected static ?string $model = StationLicense::class;

    public static function getColumns(): array
    {
        return [
            ExportColumn::make('id')
                ->label(__('station_license.id')),
            ExportColumn::make('station_name')
                ->label(__('station_license.station_name')),
            ExportColumn::make('wellLicenses.well_name')
                ->label(__('station_license.well_licenses'))
                ->listAsJson(),
            ExportColumn::make('association.name')
                ->label(__('station_license.association')),
            ExportColumn::make('status')
                ->label(__('station_license.status'))
                ->formatStateUsing(fn ($state): string => $state?->getLabel() ?? ''),
            ExportColumn::make('ministry_license_number')
                ->label(__('station_license.ministry_license_number')),
            ExportColumn::make('ministry_license_start_date')
                ->label(__('station_license.ministry_license_start_date')),
            ExportColumn::make('ministry_license_end_date')
                ->label(__('station_license.ministry_license_end_date')),
            ExportColumn::make('delegation_start_date')
                ->label(__('station_license.delegation_start_date')),
            ExportColumn::make('delegation_end_date')
                ->label(__('station_license.delegation_end_date')),
            ExportColumn::make('lat')
                ->label(__('station_license.lat')),
            ExportColumn::make('lng')
                ->label(__('station_license.lng')),
            ExportColumn::make('site_area')
                ->label(__('station_license.site_area')),
            ExportColumn::make('design_capacity')
                ->label(__('station_license.design_capacity')),
            ExportColumn::make('operation_start_date')
                ->label(__('station_license.operation_start_date')),
            ExportColumn::make('has_environmental_permit')
                ->label(__('station_license.has_environmental_permit'))
                ->formatStateUsing(fn ($state): string => $state ? __('station_license.yes') : __('station_license.no')),
            ExportColumn::make('has_evaporation_ponds')
                ->label(__('station_license.has_evaporation_ponds'))
                ->formatStateUsing(fn ($state): string => $state ? __('station_license.yes') : __('station_license.no')),
            ExportColumn::make('evaporation_ponds_count')
                ->label(__('station_license.evaporation_ponds_count')),
            ExportColumn::make('evaporation_ponds_area')
                ->label(__('station_license.evaporation_ponds_area')),
            ExportColumn::make('createdBy.name')
                ->label(__('station_license.created_by')),
            ExportColumn::make('created_at')
                ->label(__('station_license.created_at')),
            ExportColumn::make('updated_at')
                ->label(__('station_license.updated_at')),
        ];
    }

    public static function getCompletedNotificationBody(Export $export): string
    {
        $successfulRows = $export->successful_rows;
        $rowWord = $successfulRows === 1 ? __('station_license.row') : __('station_license.rows');

        $body = __('station_license.export_completed', [
            'count' => number_format($successfulRows),
            'rows' => $rowWord,
        ]);

        if ($failedRowsCount = $export->getFailedRowsCount()) {
            $failedRowWord = $failedRowsCount === 1 ? __('station_license.row') : __('station_license.rows');
            $body .= ' '.__('station_license.export_failed_rows', [
                'count' => number_format($failedRowsCount),
                'rows' => $failedRowWord,
            ]);
        }

        return $body;
    }
}
