<?php

namespace App\Filament\Exports;

use App\Models\Department;
use Filament\Actions\Exports\ExportColumn;
use Filament\Actions\Exports\Exporter;
use Filament\Actions\Exports\Models\Export;

class DepartmentExporter extends Exporter
{
    protected static ?string $model = Department::class;

    public static function getColumns(): array
    {
        return [
            ExportColumn::make('id')
                ->label(__('common.id')),
            ExportColumn::make('name')
                ->label(__('department.name')),
            ExportColumn::make('description')
                ->label(__('department.description')),
            ExportColumn::make('users_count')
                ->label(__('department.users_count'))
                ->state(function (Department $record): int {
                    return $record->users()->count();
                }),
            ExportColumn::make('created_at')
                ->label(__('common.created_at')),
            ExportColumn::make('updated_at')
                ->label(__('common.updated_at')),
        ];
    }

    public static function getCompletedNotificationBody(Export $export): string
    {
        $successfulRows = $export->successful_rows;
        $rowWord = $successfulRows === 1 ? __('common.row') : __('common.rows');

        $body = __('common.export_completed', [
            'count' => number_format($successfulRows),
            'rows' => $rowWord,
        ]);

        if ($failedRowsCount = $export->getFailedRowsCount()) {
            $failedRowWord = $failedRowsCount === 1 ? __('common.row') : __('common.rows');
            $body .= __('common.export_failed_rows', [
                'count' => number_format($failedRowsCount),
                'rows' => $failedRowWord,
            ]);
        }

        return $body;
    }
}
