<?php

namespace App\Filament\Exports;

use App\Models\Association;
use Filament\Actions\Exports\ExportColumn;
use Filament\Actions\Exports\Exporter;
use Filament\Actions\Exports\Models\Export;

class AssociationExporter extends Exporter
{
    protected static ?string $model = Association::class;

    public static function getColumns(): array
    {
        return [
            ExportColumn::make('id')
                ->label(__('association.id')),
            ExportColumn::make('name')
                ->label(__('association.name')),
            ExportColumn::make('license_number')
                ->label(__('association.license_number')),
            ExportColumn::make('license_expiration_date')
                ->label(__('association.license_expiration_date')),
            ExportColumn::make('representative_full_name')
                ->label(__('association.representative_full_name')),
            ExportColumn::make('representative_position')
                ->label(__('association.representative_position')),
            ExportColumn::make('phone_number')
                ->label(__('association.phone_number')),
            ExportColumn::make('secondary_phone_number')
                ->label(__('association.secondary_phone_number')),
            ExportColumn::make('email')
                ->label(__('association.email')),
            ExportColumn::make('city')
                ->label(__('association.city')),
            ExportColumn::make('postal_code')
                ->label(__('association.postal_code')),
            ExportColumn::make('neighborhood')
                ->label(__('association.neighborhood')),
            ExportColumn::make('building_number')
                ->label(__('association.building_number')),
            ExportColumn::make('street')
                ->label(__('association.street')),
            ExportColumn::make('branch_number')
                ->label(__('association.branch_number')),
            ExportColumn::make('lat')
                ->label(__('association.lat')),
            ExportColumn::make('lng')
                ->label(__('association.lng')),
            ExportColumn::make('iban')
                ->label(__('association.iban')),
            ExportColumn::make('bank_name')
                ->label(__('association.bank_name')),
            ExportColumn::make('account_holder_name')
                ->label(__('association.account_holder_name')),
            ExportColumn::make('is_verified')
                ->label(__('association.verification_status'))
                ->formatStateUsing(fn (bool $state): string => $state ? __('association.verified') : __('association.not_verified')),
            ExportColumn::make('is_locked')
                ->label(__('association.lock_status'))
                ->formatStateUsing(fn (bool $state): string => $state ? __('association.locked') : __('association.unlocked')),
            ExportColumn::make('profile_completion_percentage')
                ->label(__('association.profile_completion'))
                ->state(function (Association $record): string {
                    return $record->profile_completion_percentage.'%';
                }),
            ExportColumn::make('states')
                ->label(__('association.states'))
                ->state(function (Association $record): ?string {
                    $states = $record->states;

                    return $states->isNotEmpty() ? $states->pluck('name')->join(', ') : null;
                }),
            ExportColumn::make('cities')
                ->label(__('association.cities'))
                ->state(function (Association $record): ?string {
                    $cities = $record->cities;

                    return $cities->isNotEmpty() ? $cities->pluck('name')->join(', ') : null;
                }),
            ExportColumn::make('centers')
                ->label(__('association.centers'))
                ->state(function (Association $record): ?string {
                    $centers = $record->centers;

                    return $centers->isNotEmpty() ? $centers->pluck('name')->join(', ') : null;
                }),
            ExportColumn::make('orders_count')
                ->label(__('association.orders_count'))
                ->state(function (Association $record): int {
                    return $record->orders()->count();
                }),
            ExportColumn::make('created_at')
                ->label(__('common.created_at')),
            ExportColumn::make('updated_at')
                ->label(__('common.updated_at')),
        ];
    }

    public static function getCompletedNotificationBody(Export $export): string
    {
        $successfulRows = $export->successful_rows;
        $rowWord = $successfulRows === 1 ? __('association.row') : __('association.rows');

        $body = __('association.export_completed', [
            'count' => number_format($successfulRows),
            'rows' => $rowWord,
        ]);

        if ($failedRowsCount = $export->getFailedRowsCount()) {
            $failedRowWord = $failedRowsCount === 1 ? __('association.row') : __('association.rows');
            $body .= __('association.export_failed_rows', [
                'count' => number_format($failedRowsCount),
                'rows' => $failedRowWord,
            ]);
        }

        return $body;
    }
}
