<?php

namespace App\Filament\AssociationAdmin\Widgets;

use App\Models\Association;
use Filament\Widgets\Widget;
use Illuminate\Support\Facades\Auth;

/**
 * Association Registration Progress Widget
 *
 * Displays the completion percentage and steps for association profile setup.
 * The completion logic is now handled by the Association model for better
 * architecture and reusability.
 */
class AssociationRegistrationProgress extends Widget
{
    protected static string $view = 'filament.association-admin.widgets.association-registration-progress';

    protected int|string|array $columnSpan = 4;

    public int $percentage = 0;

    public ?Association $association = null;

    public array $steps = [];

    public function mount(): void
    {
        $this->association = Auth::user()->association;

        if ($this->association) {
            $this->steps = $this->association->getCompletionSteps();
            $this->percentage = $this->association->profile_completion_percentage;
        }
    }

    /**
     * Refresh the widget data
     */
    public function refresh(): void
    {
        if ($this->association) {
            $this->association->refresh();
            $this->steps = $this->association->getCompletionSteps();
            $this->percentage = $this->association->profile_completion_percentage;
        }
    }
}
