<?php

namespace App\Filament\AssociationAdmin\Widgets;

use Filament\Widgets\Widget;
use Illuminate\Support\Facades\Auth;

class AssociationDataMenus extends Widget
{
    protected static string $view = 'filament.association-admin.widgets.association-data-menus';

    protected int|string|array $columnSpan = 3;

    public string $currentSection = 'associationInfo'; // default section

    public function items(): array
    {
        $association = Auth::user()->association;

        return [
            [
                [
                    'id' => 'associationInfo',
                    'label' => __('association-file.menu_items.associationInfo'),
                    'icon' => 'heroicon-o-identification',
                ],
                [
                    'id' => 'contactInfo',
                    'label' => __('association-file.menu_items.contactInfo'),
                    'icon' => 'heroicon-o-user',
                ],
                [
                    'id' => 'nationalAddress',
                    'label' => __('association-file.menu_items.nationalAddress'),
                    'icon' => 'heroicon-o-map-pin',
                ],
                [
                    'id' => 'geographicScope',
                    'label' => __('association-file.menu_items.geographicScope'),
                    'icon' => 'heroicon-o-map',
                ],
            ],
            [
                ...$association->type === \App\Enums\AssociationType::ASSOCIATION ? [[
                    'id' => 'bankDetails',
                    'label' => __('association-file.menu_items.bankDetails'),
                    'icon' => 'heroicon-o-credit-card',
                ]] : [],
                [
                    'id' => 'documents',
                    'label' => __('association-file.menu_items.documents'),
                    'icon' => 'heroicon-o-folder',
                ],
            ],
        ];
    }

    public function setCurrentSection(string $section): void
    {
        // Emit event to check for unsaved changes before switching
        $this->dispatch('checkUnsavedChanges', $section);
    }

    public function updateCurrentSection(string $section): void
    {
        $this->currentSection = $section;
    }

    protected $listeners = ['sectionChanged' => 'updateCurrentSection'];
}
