<?php

namespace App\Filament\AssociationAdmin\Resources\AssociationWellLicenseResource\Pages;

use App\Enums\LicenseStatus;
use App\Filament\AssociationAdmin\Resources\AssociationWellLicenseResource;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Facades\Auth;

class CreateAssociationWellLicense extends CreateRecord
{
    protected static string $resource = AssociationWellLicenseResource::class;

    protected static string $view = 'filament.association-admin.resources.association-well-license-resource.pages.create-association-well-license';

    public bool $termsAccepted = false;

    public bool $showForm = false;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $data['status'] = LicenseStatus::PENDING_REQUIREMENTS;
        $data['association_id'] = Auth::user()->association_id;
        $data['created_by'] = Auth::id();

        return $data;
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    public function acceptTermsAndProceed(): void
    {
        if ($this->termsAccepted) {
            $this->showForm = true;
            $this->dispatch('close-modal', id: 'license-terms-modal');
        }
    }
}
