<?php

namespace App\Filament\AssociationAdmin\Resources\AssociationStationLicenseResource\Pages;

use App\Filament\AssociationAdmin\Imports\AssociationStationLicenseExcelImport;
use App\Filament\AssociationAdmin\Resources\AssociationStationLicenseResource;
use App\Filament\AssociationAdmin\Widgets\AssociationStationLicensesMap;
use EightyNine\ExcelImport\ExcelImportAction;
use Filament\Actions;
use Filament\Forms\Components\Actions\Action;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\ListRecords;

class ListAssociationStationLicenses extends ListRecords
{
    protected static string $resource = AssociationStationLicenseResource::class;

    protected function getHeaderActions(): array
    {
        return [
            ExcelImportAction::make()
                ->label(__('station_license.import'))
                ->color('primary')
                ->use(AssociationStationLicenseExcelImport::class)
                ->validateUsing([
                    'station_name' => 'required|string|max:255',
                    'state' => 'required|string',
                    'city' => 'required|string',
                    'center' => 'required|string',
                    'lat' => 'required|numeric|between:-90,90',
                    'lng' => 'required|numeric|between:-180,180',
                    'site_area' => 'required|numeric|min:0',
                    'design_capacity' => 'required|numeric|min:0',
                    'operation_start_date' => 'required|date',
                    'has_environmental_permit' => 'nullable|boolean',
                    'has_evaporation_ponds' => 'nullable|boolean',
                    'evaporation_ponds_count' => 'nullable|integer|min:0',
                    'evaporation_ponds_area' => 'nullable|numeric|min:0',
                    'well_licenses' => 'nullable|string',
                ])
                ->sampleExcel(
                    sampleData: [
                        [
                            'station_name' => 'محطة المعالجة 1',
                            'state' => 'القصيم',
                            'city' => 'البدائع',
                            'center' => 'الأبرق',
                            'lat' => 25.981181,
                            'lng' => 43.733409,
                            'site_area' => 5000.00,
                            'design_capacity' => 10000.00,
                            'operation_start_date' => '2024-01-15',
                            'has_environmental_permit' => true,
                            'has_evaporation_ponds' => true,
                            'evaporation_ponds_count' => 3,
                            'evaporation_ponds_area' => 1500.00,
                            'well_licenses' => 'اسم البئر 1,اسم البئر 2',
                        ],
                        [
                            'station_name' => 'محطة المعالجة 2',
                            'state' => 'القصيم',
                            'city' => 'البدائع',
                            'center' => 'الأبرق',
                            'lat' => 24.8000,
                            'lng' => 46.7000,
                            'site_area' => 7500.00,
                            'design_capacity' => 15000.00,
                            'operation_start_date' => '2024-02-20',
                            'has_environmental_permit' => false,
                            'has_evaporation_ponds' => false,
                            'evaporation_ponds_count' => 0,
                            'evaporation_ponds_area' => 0,
                            'well_licenses' => 'اسم البئر 3',
                        ],
                    ],
                    fileName: 'station_licenses_sample.xlsx',
                    customiseActionUsing: fn (Action $action) => $action
                        ->label(__('station_license.download_sample'))
                        ->icon('heroicon-m-arrow-down-tray'),
                )
                ->modalHeading(__('station_license.import'))
                ->modalDescription(__('station_license.import_description'))
                ->uploadField(
                    fn ($upload) => $upload
                        ->label(__('station_license.import_file'))
                )
                ->beforeImport(function ($data, $livewire) {
                    Notification::make()
                        ->title(__('station_license.import_started'))
                        ->body(__('station_license.import_started_body'))
                        ->info()
                        ->send();
                })
                ->afterImport(function ($data, $livewire) {
                    Notification::make()
                        ->title(__('station_license.import_completed_notification'))
                        ->body(__('station_license.import_completed_notification_body'))
                        ->success()
                        ->send();
                }),
            Actions\CreateAction::make()
                ->label(__('station_license.create_station_license')),
        ];
    }

    protected function getHeaderWidgets(): array
    {
        return [
            AssociationStationLicensesMap::class,
        ];
    }
}
