<?php

namespace App\Filament\AssociationAdmin\Resources\AssociationStationLicenseResource\Pages;

use App\Enums\LicenseStatus;
use App\Filament\AssociationAdmin\Resources\AssociationStationLicenseResource;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Facades\Auth;

class CreateAssociationStationLicense extends CreateRecord
{
    protected static string $resource = AssociationStationLicenseResource::class;

    protected static string $view = 'filament.association-admin.resources.association-station-license-resource.pages.create-association-station-license';

    public bool $termsAccepted = false;

    public bool $showForm = false;

    public function getTitle(): string
    {
        return __('station_license.create_station_license');
    }

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $data['status'] = LicenseStatus::PENDING_REQUIREMENTS;
        $data['association_id'] = Auth::user()->association_id;
        $data['created_by'] = Auth::id();

        return $data;
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    public function acceptTermsAndProceed(): void
    {
        if ($this->termsAccepted) {
            $this->showForm = true;
            $this->dispatch('close-modal', id: 'license-terms-modal');
        }
    }

    protected function afterCreate(): void
    {
        // Copy ministry_license files from attached well licenses after relationships are synced
        $this->record->copyMinistryLicensesFromWells($this->record);
    }
}
