<?php

namespace App\Filament\AssociationAdmin\Resources\AssociationProjectCharterResource\Pages;

use App\Filament\AssociationAdmin\Resources\AssociationProjectCharterResource;
use App\Utils\ProgressBarRenderer;
use Filament\Infolists\Components\Grid;
use Filament\Infolists\Components\Section;
use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Infolist;
use Filament\Resources\Pages\ViewRecord;
use Illuminate\Support\HtmlString;

class ViewAssociationProjectCharterProgress extends ViewRecord
{
    protected static string $resource = AssociationProjectCharterResource::class;

    public static function getNavigationLabel(): string
    {
        return __('project_charter.view_progress');
    }

    protected function getHeaderActions(): array
    {
        return [];
    }

    public function infolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->schema([
                $this->getProgressSection(),
            ]);
    }

    public function getProgressSection(): Section
    {
        return Section::make(__('project_charter.project_progress'))
            ->icon('heroicon-o-chart-bar')
            ->schema([
                Grid::make(3)
                    ->schema([
                        // Project Status Badge
                        TextEntry::make('project_status')
                            ->label(__('project_charter.status'))
                            ->badge()
                            ->color(fn ($record) => $record->project_status_color)
                            ->formatStateUsing(function ($state) {
                                return match ($state) {
                                    'not_started' => __('project_charter.project_status_not_started'),
                                    'in_progress' => __('project_charter.project_status_in_progress'),
                                    'late' => __('project_charter.project_status_late'),
                                    'done' => __('project_charter.project_status_done'),
                                    default => $state,
                                };
                            }),

                        // Project Progress Bar
                        TextEntry::make('project_progress')
                            ->label(__(''))
                            ->formatStateUsing(fn (string $state): HtmlString => new HtmlString(ProgressBarRenderer::render($state, __('project_charter.project_completion_percentage')))),

                        // Financial Progress Bar
                        TextEntry::make('financial_progress')
                            ->label(__(''))
                            ->formatStateUsing(fn (string $state): HtmlString => new HtmlString(ProgressBarRenderer::render($state, __('project_charter.financial_completion_percentage')))),
                    ]),
            ])
            ->columnSpanFull();
    }
}
