<?php

namespace App\Filament\AssociationAdmin\Resources\AssociationProjectCharterResource\Pages;

use App\Filament\AssociationAdmin\Resources\AssociationProjectCharterResource;
use App\Models\ProjectCharter;
use Archilex\AdvancedTables\AdvancedTables;
use Filament\Resources\Components\Tab;
use Filament\Resources\Pages\ListRecords;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;

class ListAssociationProjectCharters extends ListRecords
{
    use AdvancedTables;

    protected static string $resource = AssociationProjectCharterResource::class;

    protected function getHeaderActions(): array
    {
        return [
            // No create action for association admin
        ];
    }

    public function getTabs(): array
    {
        // Only show approved tab for association admin
        $user = Auth::user();

        if (! $user || ! $user->association_id) {
            return [];
        }

        $approvedCount = ProjectCharter::withoutGlobalScope(\App\Scopes\ViewPermissionScope::class)
            ->where('status', ProjectCharter::STATUS_APPROVED)
            ->whereHas('order', function ($orderQuery) use ($user) {
                $orderQuery->where('association_id', $user->association_id);
            })
            ->count();

        return [
            'approved' => Tab::make(__('project_charter.approved'))
                ->modifyQueryUsing(fn (Builder $query) => $query->where('status', ProjectCharter::STATUS_APPROVED))
                ->badge($approvedCount),
        ];
    }
}
