<?php

namespace App\Filament\AssociationAdmin\Resources\AssociationOrderResource\Widgets;

use App\Models\Order;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Illuminate\Support\Facades\Auth;

class AssociationOrdersStatsOverview extends BaseWidget
{
    protected function getStats(): array
    {
        $user = Auth::user();
        $associationId = $user?->association_id;

        // If user has no association, show zero stats for security
        if (! $associationId) {
            return [
                Stat::make(__('order.stats.total_orders'), 0)
                    ->description(__('order.stats.total_orders_description')),
                Stat::make(__('order.stats.pending_orders'), 0)
                    ->description(__('order.stats.pending_orders_description')),
                Stat::make(__('order.stats.accepted_orders'), 0)
                    ->description(__('order.stats.accepted_orders_description')),
            ];
        }

        return [
            Stat::make(__('order.stats.total_orders'), Order::where('association_id', $associationId)->count())
                ->description(__('order.stats.total_orders_description')),
            Stat::make(__('order.stats.pending_orders'), Order::where('association_id', $associationId)->whereIn('status', [
                Order::STATUS_CREATED,
                Order::STATUS_PENDING_RECOMMENDATION,
                Order::STATUS_RECOMMENDED,
                Order::STATUS_TECHNICAL_FINANCIAL_REQUESTED,
                Order::STATUS_TECHNICAL_FINANCIAL_APPROVED,
                Order::STATUS_PROJECT_MANAGER_APPROVED,
                Order::STATUS_CLASSIFICATION,
                Order::STATUS_AGREEMENT,
                Order::STATUS_CEO_APPROVED,
            ])->count())
                ->description(__('order.stats.pending_orders_description')),
            Stat::make(__('order.stats.accepted_orders'), Order::where('association_id', $associationId)->where('status', Order::STATUS_ACCEPTED)->count())
                ->description(__('order.stats.accepted_orders_description')),
        ];
    }
}
