<?php

namespace App\Filament\AssociationAdmin\Pages;

use App\Filament\AssociationAdmin\Widgets\AssociationDataMenus;
use App\Filament\AssociationAdmin\Widgets\AssociationMultipleForms;
use App\Filament\AssociationAdmin\Widgets\AssociationRepresentative;
use Filament\Pages\Page;

class AssociationFile extends Page
{
    protected static ?string $navigationIcon = 'heroicon-s-briefcase';

    protected static string $view = 'filament.association-admin.pages.association-file';

    protected static ?string $title = '';

    public static function getNavigationLabel(): string
    {
        return __('association-file.navigation_label');
    }

    public function getTitle(): string
    {
        return __('association.association').' - '.__('association-file.navigation_label');
    }

    public function getHeaderWidgetsColumns(): int|string|array
    {
        return 12;
    }

    protected function getHeaderWidgets(): array
    {
        return [
            // AssociationRepresentative::class,
            AssociationDataMenus::class,
            AssociationMultipleForms::class,
        ];
    }

    public static function canAccess(): bool
    {
        return true;
    }
}
