<?php

namespace App\Filament\AssociationAdmin\Pages;

use App\Enums\AssociationType;
use App\Filament\AssociationAdmin\Widgets\AssociationProjectCharterTable;
use App\Filament\AssociationAdmin\Widgets\AssociationProjectStatusChart;
use App\Filament\AssociationAdmin\Widgets\AssociationRegistrationProgress;
use App\Filament\AssociationAdmin\Widgets\AssociationStatsOverview;
use App\Filament\AssociationAdmin\Widgets\WaterRequest;
use Filament\Pages\Page;
use Illuminate\Support\Facades\Auth;

class AssociationAdminDashbaord extends Page
{
    protected static ?string $navigationIcon = 'heroicon-s-squares-2x2';

    protected static string $view = 'filament.association-admin.pages.association-admin-dashbaord';

    protected static ?string $slug = 'dashboard';

    protected static ?string $title = '';

    public static function getNavigationLabel(): string
    {
        return __('association-admin-dashboard.dashboard');
    }

    public function getTitle(): string
    {
        return __('association.association').' - '.__('association-admin-dashboard.dashboard');
    }

    public function getHeaderWidgetsColumns(): int|string|array
    {
        return 12;
    }

    protected function getHeaderWidgets(): array
    {

        $association = Auth::user()->association;
        if ($association->type !== AssociationType::ASSOCIATION) {
            return [];
        }

        return [
            WaterRequest::class,
            AssociationRegistrationProgress::class,
            AssociationStatsOverview::class,
            AssociationProjectStatusChart::class,
            AssociationProjectCharterTable::class,
        ];
    }
}
