<?php

namespace App\Events;

use App\Models\Association;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class AssociationProfileCompleted
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public Association $association;

    public int $previousCompletionPercentage;

    public int $currentCompletionPercentage;

    public string $associationEmail;

    /**
     * Create a new event instance.
     */
    public function __construct(Association $association, int $previousCompletionPercentage, int $currentCompletionPercentage)
    {
        $this->association = $association;
        $this->associationEmail = $association->email;
        $this->previousCompletionPercentage = $previousCompletionPercentage;
        $this->currentCompletionPercentage = $currentCompletionPercentage;
    }
}
