<?php

namespace App\Enums;

use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasLabel;

enum LicenseStatus: string implements HasColor, HasLabel
{
    case CREATED = 'created';
    case PENDING_REQUIREMENTS = 'pending_requirements';
    case INITIAL_APPROVAL = 'initial_approval';
    case FINAL_APPROVAL = 'final_approval';
    case APPROVED = 'approved';
    case REJECTED = 'rejected';

    public function getLabel(): ?string
    {
        return __('license_status.'.$this->value);
    }

    public function getColor(): string|array|null
    {
        return match ($this) {
            self::CREATED => 'gray',
            self::PENDING_REQUIREMENTS => 'warning',
            self::INITIAL_APPROVAL => 'info',
            self::FINAL_APPROVAL => 'warning',
            self::APPROVED => 'success',
            self::REJECTED => 'danger',
        };
    }

    public static function getOptions(): array
    {
        return collect(self::cases())->mapWithKeys(fn ($case) => [
            $case->value => $case->getLabel(),
        ])->toArray();
    }
}
