<?php

namespace App\Enums;

use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasLabel;

enum AssociationType: string implements HasColor, HasLabel
{
    case ASSOCIATION = 'association';
    case INSTITUTION = 'institution';
    case ENDOWMENT = 'endowment';

    public function getLabel(): ?string
    {
        return __('association.type.'.$this->value);
    }

    public function getColor(): string|array|null
    {
        return match ($this) {
            self::ASSOCIATION => 'success',
            self::INSTITUTION => 'info',
            self::ENDOWMENT => 'warning',
        };
    }

    public static function getOptions(): array
    {
        return collect(self::cases())->mapWithKeys(fn ($case) => [
            $case->value => $case->getLabel(),
        ])->toArray();
    }
}
