<?php

namespace App\Console\Commands;

use App\Services\OtpService;
use Illuminate\Console\Command;

class CleanupExpiredOtps extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'otp:cleanup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clean up expired OTP codes from the database';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $otpService = app(OtpService::class);
        $deletedCount = $otpService->cleanupExpiredOtps();

        $this->info("Cleaned up {$deletedCount} expired OTP codes.");
    }
}
