# Comprehensive Database Seeding Guide

This Laravel application includes a comprehensive seeding system designed to populate the database with realistic test data for development and testing purposes.

## Overview

The seeding system creates data for the entire water management workflow including:

- **User Management**: Multiple user roles (super admin, project managers, financial officers, association admins)
- **Association Management**: Various water management associations with complete profiles
- **Order Workflow**: Orders in all possible states with requirements, finances, and agreements
- **Performance Management**: Performance cards, wallets, initiatives, and projects with complete hierarchies
- **Financial Data**: Donor portfolios with realistic funding allocations
- **Geographic Data**: States, cities, and centers with family count data

## Quick Start

### Basic Seeding (Essential Data Only)
```bash
php artisan db:seed
```

### Comprehensive Seeding (All Test Data)
```bash
php artisan seed:comprehensive --all --fresh
```

### Interactive Seeding
```bash
php artisan seed:comprehensive
```

## Seeding Options

### 1. Essential Seeders (Always Run)
- Location data (states, cities, centers)
- Sekaya values (impact reasons, products)
- User roles and permissions
- Default admin user
- Basic donor portfolios

### 2. Development Seeders (Non-production)
- Sample associations with users
- Basic orders and performance cards
- Limited test data

### 3. Comprehensive Seeder (Testing)
- Extensive associations (5 complete profiles)
- Orders in all workflow states (8-15 per association)
- Complete performance management hierarchies
- Financial allocations and agreements
- Testing edge cases and scenarios

### 4. Development Factory Seeder (Realistic Data)
- Factory-generated realistic data
- Various order scenarios
- Performance hierarchies with projects
- Specific testing scenarios

## Command Options

```bash
# Run comprehensive seeder only
php artisan seed:comprehensive --comprehensive

# Run development seeder only
php artisan seed:comprehensive --development

# Run both seeders
php artisan seed:comprehensive --all

# Fresh migration + seeding
php artisan seed:comprehensive --fresh --all

# Interactive mode (choose what to seed)
php artisan seed:comprehensive
```

## Data Scenarios Created

### Order Management Scenarios
1. **Simple Approved Orders**: Basic workflow completion
2. **Complex Orders**: Multiple requirements in various states
3. **High-Value Orders**: Large infrastructure projects
4. **Emergency Orders**: Fast-track approvals
5. **Rejected Orders**: Failed approval scenarios
6. **Multi-Portfolio Funding**: Orders funded by multiple donors

### Performance Management Scenarios
1. **Complete Hierarchies**: Cards → Wallets → Initiatives → Projects → Charters
2. **Delayed Projects**: Past-due initiatives and deliverables
3. **Over-Budget Projects**: Cost overrun scenarios
4. **Quarterly Results**: Tracked performance metrics
5. **Operation Goals**: Measurable objectives with targets and actuals

### Financial Scenarios
1. **Donor Portfolio Allocations**: Realistic funding distributions
2. **Order Agreements**: Contract values and payment terms
3. **Budget Tracking**: Expected vs actual costs
4. **Emergency Reserves**: Risk management funds

## Test Users Created

| Role | Email | Password | Purpose |
|------|-------|----------|---------|
| Super Admin | superadmin@sekaya.com | Pa$$w0rd! | Full system access |
| Project Manager | pm1@sekaya.com | Pa$$w0rd! | Project oversight |
| Financial Officer | finance1@sekaya.com | Pa$$w0rd! | Financial management |
| Technical Reviewer | tech1@sekaya.com | Pa$$w0rd! | Technical approval |
| Association Admin | admin@{association}.com | Pa$$w0rd! | Association management |

## Sample Associations Created

1. **Northern Water Development Association** (Hail)
2. **Eastern Province Water Solutions** (Dammam)
3. **Western Coast Water Initiative** (Jeddah)
4. **Southern Highlands Water Council** (Abha)
5. **Central Valley Water Cooperative** (Riyadh)

Each association includes:
- Complete organizational profile
- 2-5 staff users
- 8-15 orders in various states
- Geographic service areas
- Financial allocations

## Database Tables Populated

### Core Entities
- `users` (20-30 users with various roles)
- `associations` (5-8 complete associations)
- `orders` (40-75 orders in all states)
- `order_requirements` (120-300 requirements)
- `order_finances` (80-200 financial records)
- `order_agreements` (15-30 contracts)

### Performance Management
- `performance_cards` (10-15 cards)
- `performance_wallets` (10-15 wallets)
- `initiatives` (20-45 initiatives)
- `initiative_projects` (40-180 projects)
- `project_charters` (25-125 charters)
- `initiative_operation_goals` (60-270 goals)
- `initiative_results` (40-135 results)

### Geographic & Financial
- `donor_financial_portfolios` (8-12 portfolios)
- `states` (13 Saudi regions)
- `cities` (100+ cities)
- `centers` (500+ centers with family data)

## Testing Scenarios

### Order Workflow Testing
- Test all order statuses and transitions
- Verify requirement approval/rejection flows
- Test financial calculations and agreements
- Validate donor funding allocations

### Performance Management Testing
- Test initiative creation and project hierarchies
- Verify quarterly result tracking
- Test budget vs actual cost comparisons
- Validate performance card aggregations

### Financial Management Testing
- Test multi-portfolio funding scenarios
- Verify contract value calculations
- Test over-budget detection
- Validate payment schedules

### Geographic Testing
- Test location-based filtering
- Verify center-order relationships
- Test service area coverage calculations

## Development Workflow

1. **Fresh Start**: `php artisan seed:comprehensive --fresh --all`
2. **Development Testing**: Use created users to test different workflows
3. **Data Reset**: Re-run seeding when needed for clean testing
4. **Scenario Testing**: Use specific created scenarios to test edge cases

## Maintenance

### Adding New Scenarios
1. Extend `ComprehensiveSeeder` for new data patterns
2. Add factory states in `DevelopmentSeeder` for realistic variations
3. Update command summary to reflect new data

### Performance Considerations
- Comprehensive seeding creates 1000+ database records
- Use `--fresh` flag to avoid constraint conflicts
- Consider running in database transactions for consistency

## Troubleshooting

### Common Issues
1. **Foreign Key Constraints**: Use `--fresh` flag for clean start
2. **Memory Limits**: Increase PHP memory limit for large datasets
3. **Unique Constraints**: Factories handle uniqueness automatically

### Reset Commands
```bash
# Complete reset
php artisan migrate:fresh --seed

# Reset with comprehensive data
php artisan seed:comprehensive --fresh --all

# Check data integrity
php artisan tinker
> User::count(); Order::count(); // etc.
```

This comprehensive seeding system ensures you have realistic, complete test data to verify all aspects of the water management system functionality.
