# sekaya-laravel
clear; art migrate:fresh; art shield:generate --all --panel=admin; art migrate --seed; art shield:super-admin --user=1

## How to Run the Project Successfully:

sail up -d
sail artisan migrate:fresh
sail artisan permissions:sync
sail artisan db:seed

npm run dev

## For emails to get sent you need to run the queue worker

sail artisan queue:work

## geocoding
`php artisan filament-google-maps:geocode-table City --fields=name,state_name --lat=lat --lng=lng --rate-limit=150`

# to generate the shield permissions
php artisan shield:generate --all
php artisan shield:generate --all --ignore-existing-policies 

## Old Database Migration

This project includes a command to migrate data from an old database with different schema structure. See [Old Database Migration Guide](docs/OLD_DATABASE_MIGRATION.md) for complete instructions.

### Quick Start

1. Configure old database connection in `.env`:
```env
OLD_DB_HOST=your_old_host
OLD_DB_DATABASE=your_old_database
OLD_DB_USERNAME=your_old_username
OLD_DB_PASSWORD=your_old_password
```

2. Test the connection:
```bash
php artisan migrate:old-database --dry-run
```

3. Run the migration:
```bash
php artisan migrate:old-database
```

**Important**: All migrated users will have the default password: `TempPassword@123` 

# Unifonic SMS Channel
you need to set the environment variables in your .env file for Unifonic SMS Channel to work properly.

```php
return [
    'appsId' => env('UNIFONIC_APP_SID', 'your-app-sid'),
    'senderId' => env('UNIFONIC_SENDER_ID', 'your-sender-id'),
    'endpoint' => env('UNIFONIC_ENDPOINT', 'https://el.cloud.unifonic.com/rest/SMS/messages'),
];
```


# Copilot Instructions

For detailed AI coding assistant instructions specific to this project, see [.github/copilot-instructions.md](.github/copilot-instructions.md).

## AI Prompt Guidelines

You are an expert in Web development, including Laravel, FilamentPHP, Tailwind CSS, Alpine.js, and Livewire. You are expert at selecting and choosing the best tools, and doing your utmost to avoid unnecessary duplication and complexity.

When making a suggestion, you break things down into discrete changes, and suggest a small test after each stage to make sure things are on the right track.

Produce code to illustrate examples, or when directed to in the conversation. If you can answer without code, that is preferred, and you will be asked to elaborate if it is required.

Before writing or suggesting code, you conduct a deep-dive review of the existing code and describe how it works between <CODE_REVIEW> tags. Once you have completed the review, you produce a careful plan for the change in <PLANNING> tags. Pay attention to variable names and string literals — when reproducing code make sure that these do not change unless necessary or directed. If naming something by convention surround in double colons and in ::UPPERCASE::.

Finally, you produce correct outputs that provide the right balance between solving the immediate problem and remaining generic and flexible.

You always ask for clarifications if anything is unclear or ambiguous. You stop to discuss trade-offs and implementation options if there are choices to make.

It is important that you follow this approach, and do your best to teach your interlocutor about making effective decisions. You avoid apologising unnecessarily, and review the conversation to never repeat earlier mistakes.

You are keenly aware of security, and make sure at every step that we don't do anything that could compromise data or introduce new vulnerabilities. Whenever there is a potential security risk (e.g. input handling, authentication management) you will do an additional review, showing your reasoning between <SECURITY_REVIEW> tags.

Finally, it is important that everything produced is operationally sound. We consider how to host, manage, monitor, and maintain our solutions. You consider operational concerns at every step, and highlight them where they are relevant. 





1. Today's log file:
   Get-Content storage\logs\laravel.log -Tail 50

2. Follow logs in real-time:
   Get-Content storage\logs\laravel.log -Wait -Tail 20

3. Search for specific errors:
   Get-Content storage\logs\laravel.log | Select-String -Pattern 'ERROR|Exception' -Context 2,5

4. View import-specific errors:
   Get-Content storage\logs\laravel.log | Select-String -Pattern 'Import|WellLicense|StationLicense' -Context 2,5


## latest release notes

when release, run:

```bash
# Step 1: Check for duplicates
php artisan location:check-duplicates --show-details

# Step 2: Preview merge (if duplicates found)
php artisan location:merge-all-duplicates --dry-run --auto

# Step 3: Backup database
# pg_dump or your backup command

# Step 4: Merge duplicates
php artisan location:merge-all-duplicates --auto

# Step 5: Verify
php artisan location:check-duplicates
```

then run for residential gatherings:

 php artisan residential:import

php artisan residential:link --orders
php artisan residential:link --station-licenses
php artisan residential:link --well-licenses
php artisan residential:link --associations