<?php

namespace Tests\Unit;

use App\Filament\Admin\Resources\Departments\DepartmentResource;
use App\Filament\Admin\Resources\Departments\Forms\DepartmentForm;
use App\Filament\Admin\Resources\Departments\Tables\DepartmentTable;
use App\Models\Department;
use PHPUnit\Framework\TestCase;

class DepartmentResourceTest extends TestCase
{
    public function test_department_resource_has_correct_model(): void
    {
        $this->assertEquals(Department::class, DepartmentResource::getModel());
    }

    public function test_department_resource_has_permission_prefixes(): void
    {
        $prefixes = DepartmentResource::getPermissionPrefixes();

        $this->assertIsArray($prefixes);
        $this->assertContains('view', $prefixes);
        $this->assertContains('create', $prefixes);
        $this->assertContains('update', $prefixes);
        $this->assertContains('delete', $prefixes);
    }

    public function test_department_resource_has_navigation_icon(): void
    {
        $this->assertEquals('heroicon-o-building-office-2', DepartmentResource::getNavigationIcon());
    }

    public function test_department_resource_classes_exist(): void
    {
        $this->assertTrue(class_exists(DepartmentForm::class));
        $this->assertTrue(class_exists(DepartmentTable::class));
    }

    public function test_department_form_has_configure_method(): void
    {
        $this->assertTrue(method_exists(DepartmentForm::class, 'configure'));
    }

    public function test_department_table_has_configure_method(): void
    {
        $this->assertTrue(method_exists(DepartmentTable::class, 'configure'));
    }
}
