<?php

namespace Tests\Feature;

use Tests\TestCase;

class WorkflowTemplateTranslationTest extends TestCase
{
    /**
     * Test that all workflow template translation keys are available.
     */
    public function test_workflow_template_translations_are_available(): void
    {
        // Set Arabic locale
        app()->setLocale('ar');

        // Test main navigation labels
        $this->assertEquals('قوالب سير العمل', __('workflow.templates.navigation_label'));
        $this->assertEquals('قالب سير العمل', __('workflow.templates.singular_label'));
        $this->assertEquals('قوالب سير العمل', __('workflow.templates.plural_label'));
        $this->assertEquals('إدارة سير العمل', __('workflow.templates.navigation_group'));

        // Test page titles
        $this->assertEquals('قوالب سير العمل', __('workflow.templates.list_title'));
        $this->assertEquals('إنشاء قالب سير العمل', __('workflow.templates.create_title'));
        $this->assertEquals('تحرير قالب سير العمل', __('workflow.templates.edit_title'));

        // Test form fields
        $this->assertEquals('الاسم', __('workflow.templates.name'));
        $this->assertEquals('نوع الموضوع', __('workflow.templates.subject_type'));
        $this->assertEquals('نشط', __('workflow.templates.is_active'));

        // Test table columns
        $this->assertEquals('الاسم', __('workflow.templates.table_name'));
        $this->assertEquals('نوع الموضوع', __('workflow.templates.table_subject_type'));
        $this->assertEquals('نشط', __('workflow.templates.table_active'));

        // Test actions
        $this->assertEquals('نشر', __('workflow.templates.actions.publish'));
        $this->assertEquals('استنسخ', __('workflow.templates.actions.clone'));

        // Test step template relation
        $this->assertEquals('خطوات القالب', __('workflow.templates.step_templates.tab_label'));
        $this->assertEquals('اسم الخطوة', __('workflow.templates.step_templates.name'));
        $this->assertEquals('مفتاح النظام', __('workflow.templates.step_templates.system_key'));

        // Test notifications with parameters
        $this->assertEquals('تم إنشاء قالب مسودة: Test Template',
            __('workflow.templates.cloned_body', ['name' => 'Test Template']));
    }

    /**
     * Test that translation keys don't return the key itself (fallback behavior).
     */
    public function test_translations_do_not_fallback_to_key(): void
    {
        app()->setLocale('ar');

        // These should return Arabic text, not the key itself
        $translations = [
            'workflow.templates.navigation_label',
            'workflow.templates.name',
            'workflow.templates.actions.publish',
            'workflow.templates.step_templates.tab_label',
        ];

        foreach ($translations as $key) {
            $translation = __($key);
            $this->assertNotEquals($key, $translation, "Translation key '{$key}' is not translated");
            $this->assertNotEmpty($translation, "Translation for '{$key}' should not be empty");
        }
    }
}
