<?php

namespace Tests\Feature;

use App\Filament\Admin\Resources\Users\UserResource;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class UserResourceTest extends TestCase
{
    use RefreshDatabase;

    public function test_user_resource_has_correct_model(): void
    {
        $this->assertEquals(User::class, UserResource::getModel());
    }

    public function test_user_resource_has_permission_prefixes(): void
    {
        $prefixes = UserResource::getPermissionPrefixes();

        $this->assertIsArray($prefixes);
        $this->assertContains('view', $prefixes);
        $this->assertContains('create', $prefixes);
        $this->assertContains('update', $prefixes);
        $this->assertContains('delete', $prefixes);
    }

    public function test_user_resource_has_navigation_label(): void
    {
        $label = UserResource::getNavigationLabel();
        $this->assertNotEmpty($label);
    }

    public function test_user_resource_has_model_labels(): void
    {
        $modelLabel = UserResource::getModelLabel();
        $pluralLabel = UserResource::getPluralModelLabel();

        $this->assertNotEmpty($modelLabel);
        $this->assertNotEmpty($pluralLabel);
    }

    public function test_user_resource_has_pages(): void
    {
        $pages = UserResource::getPages();

        $this->assertIsArray($pages);
        $this->assertArrayHasKey('index', $pages);
        $this->assertArrayHasKey('create', $pages);
        $this->assertArrayHasKey('view', $pages);
        $this->assertArrayHasKey('edit', $pages);
    }
}
