@php
    $goals = $getRecord()->operationGoals;
@endphp

<div class="space-y-4">
    @if($goals->isEmpty())
        <div class="text-gray-500 text-center py-8">
            <svg class="w-12 h-12 mx-auto mb-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
            </svg>
            <p class="text-sm">{{ __('initiative_operation_goal.no_goals_yet') }}</p>
        </div>
    @else
        <div class="max-h-96 overflow-y-auto space-y-4">
            @foreach($goals as $goal)
                <div class="border rounded-lg p-4 bg-gray-50 dark:bg-gray-800 hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors duration-200 relative">
                    {{-- Action buttons (always visible at top-end) --}}
                    <div class="absolute top-2 end-2 flex space-x-1 z-10">
                        {{-- Edit button --}}
                        <button 
                            type="button"
                            wire:click="mountAction('editGoal', {{ json_encode(['goal' => $goal->id]) }})"
                            class="p-1.5 text-blue-600 hover:text-blue-800 hover:bg-blue-100 dark:hover:bg-blue-900 rounded-md transition-colors duration-200 bg-white dark:bg-gray-700 shadow-sm border border-gray-200 dark:border-gray-600"
                            title="{{ __('filament-actions::edit.single.label') }}"
                        >
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                            </svg>
                        </button>
                        
                        {{-- Delete button --}}
                        <button 
                            type="button"
                            wire:click="mountAction('deleteGoal', {{ json_encode(['goal' => $goal->id]) }})"
                            class="p-1.5 text-red-600 hover:text-red-800 hover:bg-red-100 dark:hover:bg-red-900 rounded-md transition-colors duration-200 bg-white dark:bg-gray-700 shadow-sm border border-gray-200 dark:border-gray-600"
                            title="{{ __('filament-actions::delete.single.label') }}"
                        >
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                            </svg>
                        </button>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 pt-4">
                        {{-- Goal Name --}}
                        <div class="space-y-1">
                            <dt class="text-xs font-medium text-gray-500 dark:text-gray-400">
                                {{ __('initiative_operation_goal.name') }}
                            </dt>
                            <dd class="text-sm font-semibold text-gray-900 dark:text-gray-100">
                                {{ $goal->name }}
                            </dd>
                        </div>

                        {{-- Performance Criteria --}}
                        <div class="space-y-1">
                            <dt class="text-xs font-medium text-gray-500 dark:text-gray-400">
                                {{ __('initiative_operation_goal.performance_criteria') }}
                            </dt>
                            <dd class="text-sm text-gray-900 dark:text-gray-100">
                                {{ $goal->performance_criteria }}
                            </dd>
                        </div>

                        {{-- Target --}}
                        <div class="space-y-1">
                            <dt class="text-xs font-medium text-gray-500 dark:text-gray-400">
                                {{ __('initiative_operation_goal.target') }}
                            </dt>
                            <dd class="text-sm font-medium text-blue-600 dark:text-blue-400">
                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs bg-blue-100 dark:bg-blue-900">
                                    {{ $goal->target }}
                                </span>
                            </dd>
                        </div>

                        {{-- Actual --}}
                        <div class="space-y-1">
                            <dt class="text-xs font-medium text-gray-500 dark:text-gray-400">
                                {{ __('initiative_operation_goal.actual') }}
                            </dt>
                            <dd class="text-sm">
                                @if($goal->actual)
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs bg-green-100 dark:bg-green-900 text-green-600 dark:text-green-400">
                                        {{ $goal->actual }}
                                    </span>
                                @else
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs bg-gray-100 dark:bg-gray-700 text-gray-500 dark:text-gray-400">
                                        {{ __('initiative_operation_goal.not_measured_yet') }}
                                    </span>
                                @endif
                            </dd>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @endif
</div>

{{-- Action Modals --}}
<x-filament-actions::modals />
