<?php

return [
    // Workflow States
    'states' => [
        'running' => 'Running',
        'completed' => 'Completed',
        'rejected' => 'Rejected',
        'canceled' => 'Canceled',
    ],

    // Step States
    'step_states' => [
        'pending' => 'Pending',
        'approved' => 'Approved',
        'rejected' => 'Rejected',
        'skipped' => 'Skipped',
    ],

    // Status Labels
    'status' => [
        'no_workflow' => 'No Workflow',
        'new' => 'New',
        'in_progress' => 'In Progress',
        'step_with_status' => ':step (:status)',
    ],

    // Actions
    'actions' => [
        'start_workflow' => 'Start Workflow',
        'review_step' => 'Review / Next Step',
        'reject_step' => 'Reject Step',
        'approve_step' => 'Approve Step',
        'cancel_workflow' => 'Cancel Workflow',
    ],

    // Action Descriptions
    'descriptions' => [
        'start_workflow' => 'Start the workflow process for this item',
        'review_step' => 'Review and approve the current workflow step',
        'reject_step' => 'Reject the current workflow step with comments',
        'approve_step' => 'Approve the current workflow step',
        'cancel_workflow' => 'Cancel the entire workflow process',
    ],

    // Form Labels
    'forms' => [
        'rejection_reason' => 'Rejection Reason',
        'rejection_reason_placeholder' => 'Please provide a reason for rejection...',
        'comments' => 'Comments',
        'comments_placeholder' => 'Add any additional comments...',
        'workflow_type' => 'Workflow Type',
        'step_name' => 'Step Name',
        'assigned_to' => 'Assigned To',
        'due_date' => 'Due Date',
    ],

    // Notifications
    'notifications' => [
        'workflow_started' => 'Workflow started successfully',
        'workflow_start_failed' => 'Failed to start workflow',
        'step_approved' => 'Step approved successfully',
        'step_approval_failed' => 'Failed to approve step',
        'step_rejected' => 'Step rejected successfully',
        'step_rejection_failed' => 'Failed to reject step',
        'workflow_canceled' => 'Workflow canceled successfully',
        'workflow_cancel_failed' => 'Failed to cancel workflow',
        'no_current_step' => 'No current step found',
    ],

    // Activity Log Messages
    'activity' => [
        'workflow_started' => 'Workflow started',
        'workflow_auto_started' => 'Auto-initialized when viewing record',
        'step_approved' => 'Step \':from_step\' approved',
        'step_approved_with_next' => 'Step \':from_step\' approved → \':to_step\'',
        'step_approved_completed' => 'Step \':from_step\' approved (completed)',
        'step_rejected' => 'Step \':step\' rejected: :reason',
        'workflow_completed' => 'Workflow completed successfully',
        'workflow_canceled' => 'Workflow canceled: :reason',
        'step_approved_by' => 'Approved \':from_step\' by :name',
        'step_status_changed' => 'Status changed from <strong>:from_step</strong> to <strong>:to_step</strong>.',
        'step_rejected_by' => 'Rejected \':from_step\' by :name',
        'step_status_was' => 'Status was <strong>:status</strong>.',
        'workflow_completed_by' => 'Workflow completed by :name.',
        'workflow_notes' => 'Notes: :notes',
        'workflow_notes_na' => 'No notes available',
    ],

    // Errors
    'errors' => [
        'no_active_template' => 'No active workflow template found for :model',
        'only_pending_can_be_approved' => 'Only pending steps can be approved',
        'only_pending_can_be_rejected' => 'Only pending steps can be rejected',
        'user_not_authenticated' => 'User must be authenticated to perform workflow actions',
        'no_permission' => 'User does not have permission: :permission',
        'validation_failed' => 'Validation failed: :error',
        'cannot_cancel_completed' => 'Cannot cancel completed workflow',
        'handler_not_whitelisted' => 'Handler class :class is not whitelisted',
        'handler_not_found' => 'Handler class :class does not exist',
        'handler_invalid' => 'Handler :class must implement StepHandler interface',
    ],

    // Confirmations
    'confirmations' => [
        'reject_step' => 'Are you sure you want to reject this step?',
        'cancel_workflow' => 'Are you sure you want to cancel this workflow?',
        'start_workflow' => 'Are you sure you want to start the workflow?',
    ],

    // General
    'general' => [
        'workflow' => 'Workflow',
        'workflows' => 'Workflows',
        'step' => 'Step',
        'steps' => 'Steps',
        'status' => 'Status',
        'actions' => 'Actions',
        'history' => 'History',
        'details' => 'Details',
        'progress' => 'Progress',
        'version' => 'Version',
    ],

    // Templates
    'templates' => [
        'navigation_label' => 'Workflow Templates',
        'singular_label' => 'Workflow Template',
        'plural_label' => 'Workflow Templates',
        'list_title' => 'Workflow Templates',
        'create_title' => 'Create Workflow Template',
        'edit_title' => 'Edit Workflow Template',

        'name' => 'Name',
        'name_help' => 'Enter a descriptive name for this workflow template',
        'subject_type' => 'Subject Type',
        'subject_type_help' => 'The model type this workflow applies to',
        'subject_type_placeholder' => 'Select a model type...',
        'is_active' => 'Active',
        'is_active_help' => 'Whether this template is active and can be used',
        'status' => 'Status',
        'version' => 'Version',
        'published_at' => 'Published At',
        'not_published' => 'Not published',
        'draft' => 'Draft',

        'table_name' => 'Name',
        'table_status' => 'Status',
        'table_subject_type' => 'Subject Type',
        'table_active' => 'Active',
        'table_created' => 'Created At',

        'filter_status' => 'Status',
        'filter_active' => 'Active',

        'status_draft' => 'Draft',
        'status_published' => 'Published',
        'status_archived' => 'Archived',

        'actions' => [
            'publish' => 'Publish',
            'clone' => 'Clone',
        ],

        'published' => 'Template published successfully',
        'publish_failed' => 'Failed to publish template',
        'cloned' => 'Template cloned successfully',
        'cloned_body' => 'A new draft version has been created: :name',

        'step_templates' => [
            'tab_label' => 'Step Templates',
            'name' => 'Step Name',
            'name_help' => 'Enter a descriptive name for this workflow step',
            'system_key' => 'System Key',
            'system_key_help' => 'Choose a system key to identify this step type',
            'position' => 'Position',
            'step_template' => 'Step Template',
            'step_template_help' => 'Choose a predefined template with form fields and validation',
            'locked' => 'Locked',
            'form' => 'Form',
            'template' => 'Template',
            'type' => 'Type',
            'none_placeholder' => 'None',
            'basic_step' => 'Basic Step',

            'system_key_required' => 'Required system key for this workflow',
            'system_key_optional' => 'Optional system key',
            'system_key_none' => 'None',
            'no_key_assigned' => 'No system key assigned',
            'required_keys_help' => 'Required system keys for this workflow: :keys',
            'choose_key_help' => 'Choose a system key to identify this step type',

            'type_approval' => 'Approval',
            'type_input' => 'Input',
            'type_auto' => 'Auto',
        ],
    ],

    // Tab Permissions
    'tab_permissions' => [
        'view_all' => 'View All Tab',
        'view_new' => 'View New Tab',
        'view_completed' => 'View Completed Tab',
        'view_rejected' => 'View Rejected Tab',
        'view_step' => 'View Step Tab',
    ],
];
