<?php

return [
    'association' => 'Association',
    'associations' => 'Associations',

    'page_title' => 'Association Registration',
    'page_subtitle' => 'Complete registration to submit a support request',

    'name' => 'Association Name',
    'name_placeholder' => 'Enter association name',

    'license_number' => 'Association License Number',
    'license_number_placeholder' => 'Enter license number',
    'license_number_no_leading_zero' => 'License number cannot start with zero',

    'license_expiration_date' => 'License Expiration Date',

    'representative' => 'Association Representative',
    'representative_placeholder' => "Enter representative's name",

    'position' => 'Representative\'s Position',
    'position_placeholder' => "Enter representative's position",

    'phone_number' => 'Mobile Number',
    'phone_number_placeholder' => '056xxxxxxx',

    'secondary_phone_number' => 'Second Mobile Number',
    'secondary_phone_number_placeholder' => '056xxxxxxx',

    'email' => 'Email Address',
    'email_placeholder' => 'info@example.com',

    'logo' => 'Association Logo',
    'logo_placeholder' => 'Upload association logo',

    // --- National Address ---
    'map_location' => 'Association Location',
    'map_location_placeholder' => 'Enter location',

    'city' => 'City',
    'city_placeholder' => 'Enter city name',

    'postal_code' => 'Postal Code',
    'postal_code_placeholder' => 'Enter postal code',

    'neighborhood' => 'Neighborhood',
    'neighborhood_placeholder' => 'Enter neighborhood name',

    'building_number' => 'Building Number',
    'building_number_placeholder' => 'Enter building number',

    'street' => 'Street',
    'street_placeholder' => 'Enter street name',

    'branch_number' => 'Branch Number',
    'branch_number_placeholder' => 'Enter branch number',

    // --- Geographic Scope ---
    'regions' => 'Regions',
    'regions_placeholder' => 'Select regions (you can select more than one)',

    'governorates' => 'Governorates',
    'governorates_placeholder' => 'Select governorates (you can select more than one)',

    'centers' => 'Centers',
    'centers_placeholder' => 'Select centers (you can select more than one)',

    'villages' => 'Villages',
    'villages_placeholder' => 'Select villages (you can select more than one)',

    // --- Bank Details ---
    'iban' => 'IBAN Number',
    'iban_placeholder' => 'Enter IBAN',

    'bank_name' => 'Bank Name',
    'bank_name_placeholder' => 'Enter bank name',

    'account_holder_name' => 'Account Holder Full Name',
    'account_holder_name_placeholder' => 'Enter full account holder name',

    'iban_certificate_path' => 'IBAN Certificate File',

    // --- Document Uploads ---
    'authorization_letter' => 'Authorization Letter',
    'license_certificate' => 'Association License Certificate',
    'iban_certificate' => 'IBAN Certificate',
    'national_address_certificate' => 'National Address Certificate',
    'governance_certificate' => 'Governance Certificate',
    'financial_reports' => 'Financial Reports',
    'basic_bylaws' => 'Basic Bylaws',

    'authorization_letter_upload' => 'Signed and Stamped Authorization Letter',

    'license_upload' => 'Association License Document',

    'register' => 'Register',
    'already_have_account' => 'Already have an account?',
    'login' => 'Login',

    // Section titles and descriptions
    'association_information' => 'Association Information',
    'association_information_description' => 'Basic information about the association',
    'contact_information' => 'Contact Information',
    'contact_information_description' => 'Phone numbers and email address',
    'national_address' => 'National Address',
    'national_address_description' => 'Complete address details',
    'geographic_scope' => 'Geographic Scope',
    'geographic_scope_description' => 'Areas covered by the association',
    'banking_details' => 'Banking Details',
    'banking_details_description' => 'Bank account information',
    'documents' => 'Documents',
    'documents_description' => 'Required certificates and documents',
    'status_section' => 'Status',
    'status_section_description' => 'Current approval status',

    // Geographic regions
    'region_riyadh' => 'Riyadh Region',
    'region_makkah' => 'Makkah Region',
    'region_eastern' => 'Eastern Region',
    'region_asir' => 'Asir Region',
    'region_jazan' => 'Jazan Region',
    'region_tabuk' => 'Tabuk Region',
    'region_hail' => 'Hail Region',
    'region_northern_border' => 'Northern Border Region',
    'region_najran' => 'Najran Region',
    'region_baha' => 'Al Bahah Region',
    'region_qassim' => 'Al Qassim Region',
    'region_medina' => 'Medina Region',
    'region_jouf' => 'Al Jouf Region',

    'status' => 'Status',

    'status_pending' => 'Pending',
    'status_approved' => 'Approved',
    'status_rejected' => 'Rejected',
    'status_suspended' => 'Suspended',

    'action_approve' => 'Approve',
    'action_reject' => 'Reject Request',
    'action_suspend' => 'Suspend',
    // View page specific
    'document_available' => 'Available',
    'document_not_available' => 'Not Available',

    // Verification and Lock Actions
    'action_verify' => 'Verify Association',
    'action_unverify' => 'Unverify Association',
    'action_lock' => 'Lock Profile',
    'action_unlock' => 'Unlock Profile',

    // Form section
    'verification_lock_section' => 'Verification & Profile Control',
    'verification_lock_section_description' => 'Manage association verification status and profile access control.',
    'is_verified' => 'Verified Status',
    'is_verified_helper' => 'Mark this association as verified',
    'is_locked' => 'Profile Locked',
    'is_locked_helper' => 'Lock this association profile to prevent modifications',

    // Confirmation messages
    'confirm_verify_title' => 'Verify Association',
    'confirm_verify_description' => 'Are you sure you want to verify this association? This action will mark the association as verified.',
    'confirm_unverify_title' => 'Unverify Association',
    'confirm_unverify_description' => 'Are you sure you want to unverify this association? This action will remove the verified status.',
    'confirm_lock_title' => 'Lock Association Profile',
    'confirm_lock_description' => 'Are you sure you want to lock this association profile? This will prevent any modifications.',
    'confirm_unlock_title' => 'Unlock Association Profile',
    'confirm_unlock_description' => 'Are you sure you want to unlock this association profile? This will allow modifications.',

    // Status labels
    'verification_status' => 'Verification Status',
    'profile_completion' => 'Profile Completion',
    'lock_status' => 'Profile Status',
    'verified' => 'Verified',
    'not_verified' => 'Not Verified',
    'locked' => 'Locked',
    'unlocked' => 'Unlocked',

    // Profile locked messages
    'profile_locked_title' => 'Profile is Locked',
    'profile_locked_message' => 'This association profile is locked and cannot be modified. Please contact an administrator to unlock the profile.',

    // Registration error messages
    'email_already_registered' => 'This email address is already registered. Please use a different email or login to your existing account.',
    'phone_number_already_registered' => 'This phone number is already registered. Please use a different phone number or login to your existing account.',
    'registration_failed' => 'Registration failed, please try again.',

    // Detailed registration error messages
    'user_creation_failed' => 'Failed to create user account. Please check your information and try again.',
    'association_creation_failed' => 'Failed to create association record. Please verify all required information is provided.',
    'role_assignment_failed' => 'User account created but role assignment failed. Please contact support.',
    'file_upload_failed' => 'Failed to process uploaded files. Please ensure all files are valid and try again.',
    'file_not_found' => 'One or more uploaded files could not be found. Please re-upload your files.',
    'file_processing_error' => 'Error processing uploaded files. Please check file formats and sizes.',
    'database_error' => 'A database error occurred during registration. Please try again or contact support.',
    'storage_error' => 'File storage error occurred. Please try again or contact support if the problem persists.',
    'system_error' => 'A system error occurred. Please try again later or contact support if the problem persists.',
    'invalid_otp' => 'The OTP you entered is invalid or expired. Please try again.',

    'states' => 'States',
    'cities' => 'Cities',
    'location' => 'Location on Map',
];
