<?php

namespace Database\Seeders;

use App\Models\Order;
use App\Models\Org;
use App\Models\ProjectCharter;
use App\Workflows\Models\StepTemplate;
use App\Workflows\Models\WorkflowTemplate;
use Illuminate\Database\Seeder;

class WorkflowSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the first organization (or create one if none exists)
        $orgs = Org::all();

        foreach ($orgs as $org) {
            $this->createOrderWorkflow($org);
            $this->createProjectCharterWorkflow($org);
        }

        $this->command->info('تم تنفيذ بذر سير العمل بنجاح!');
        $this->command->info('تم إنشاء 7 قوالب خطوات: دراسة، موافقة، تصنيف (مع حقول الشؤون المالية)، اتفاقية (مع حقول الاتفاقية)، إطلاق، معتمد، مرفوض');
    }

    private function createOrderWorkflow(Org $org)
    {
        // Create a draft workflow template for Orders
        $workflowTemplate = WorkflowTemplate::create([
            'org_id' => $org->id,
            'name' => 'سير عمل اعتماد الطلبات',
            'subject_type' => Order::class,
            'status' => 'draft',
            'version' => 1,
            'is_active' => false,
        ]);

        // Create step templates
        StepTemplate::create([
            'workflow_template_id' => $workflowTemplate->id,
            'position' => 1,
            'type' => 'approval',
            'system_key' => 'study',
            'label' => 'دراسة',
        ]);

        StepTemplate::create([
            'workflow_template_id' => $workflowTemplate->id,
            'position' => 2,
            'type' => 'approval',
            'system_key' => 'approval',
            'label' => 'موافقة',
        ]);

        StepTemplate::create([
            'workflow_template_id' => $workflowTemplate->id,
            'position' => 3,
            'type' => 'approval',
            'system_key' => 'classification',
            'label' => 'تصنيف',
            'form_definition' => config('workflows.step_templates.finance_fields_and_bindings.form_definition'),
            'validation' => config('workflows.step_templates.finance_fields_and_bindings.validation'),
            'data_bindings' => config('workflows.step_templates.finance_fields_and_bindings.data_bindings'),
        ]);

        StepTemplate::create([
            'workflow_template_id' => $workflowTemplate->id,
            'position' => 4,
            'type' => 'approval',
            'system_key' => 'agreement',
            'label' => 'اتفاقية',
            'form_definition' => config('workflows.step_templates.agreement_fields_and_bindings.form_definition'),
            'validation' => config('workflows.step_templates.agreement_fields_and_bindings.validation'),
            'data_bindings' => config('workflows.step_templates.agreement_fields_and_bindings.data_bindings'),
        ]);

        StepTemplate::create([
            'workflow_template_id' => $workflowTemplate->id,
            'position' => 5,
            'type' => 'approval',
            'system_key' => 'launch',
            'label' => 'إطلاق',
        ]);

        $this->command->info("تم إنشاء قالب سير العمل: {$workflowTemplate->name}");
    }

    private function createProjectCharterWorkflow(Org $org)
    {
        // Create a draft workflow template for Project Charters
        $workflowTemplate = WorkflowTemplate::create([
            'org_id' => $org->id,
            'name' => 'سير عمل اعتماد ميثاق المشروع',
            'subject_type' => ProjectCharter::class,
            'status' => 'draft',
            'version' => 1,
            'is_active' => false,
        ]);

        // Create step templates
        StepTemplate::create([
            'workflow_template_id' => $workflowTemplate->id,
            'position' => 1,
            'type' => 'approval',
            'system_key' => 'draft',
            'label' => 'مسودة',
        ]);

        StepTemplate::create([
            'workflow_template_id' => $workflowTemplate->id,
            'position' => 2,
            'type' => 'approval',
            'system_key' => 'approval',
            'label' => 'موافقة',
        ]);

        $this->command->info("تم إنشاء قالب سير العمل: {$workflowTemplate->name}");
    }
}
