<?php

namespace Database\Seeders;

use App\Models\Org;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class SuperAdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create the super admin user
        $superAdmin = User::firstOrCreate(
            [
                'email' => 'admin@sadu.com',
            ],
            [
                'name' => 'مدير النظام',
                'phone' => '+966555999111',
                'password' => Hash::make('Test@123'),
                'email_verified_at' => now(),
            ]
        );

        $superAdmin2 = User::firstOrCreate(
            [
                'email' => 'admin-reef@sadu.com',
            ],
            [
                'name' => 'مدير النظام ريف',
                'phone' => '+966555999222',
                'password' => Hash::make('Test@123'),
                'email_verified_at' => now(),
            ]
        );

        $superAdmin3 = User::firstOrCreate(
            [
                'email' => 'admin-muttab@sadu.com',
            ],
            [
                'name' => 'مدير النظام متعب',
                'phone' => '+966555999333',
                'password' => Hash::make('Test@123'),
                'email_verified_at' => now(),
            ]
        );

        $orgs = [
            Org::firstOrCreate(['name' => 'مؤسسة سدو']),
            Org::firstOrCreate(['name' => 'مؤسسة ريف']),
            Org::firstOrCreate(['name' => 'مؤسسة متعب']),
        ];

        $orgs[0]->users()->save($superAdmin);
        $orgs[1]->users()->save($superAdmin2);
        $orgs[2]->users()->save($superAdmin3);

        $this->command->info('تم إنشاء مدير النظام بنجاح!');
        $this->command->info('البريد الإلكتروني: '.$superAdmin->email);
        $this->command->info('الجوال: '.$superAdmin->phone);
        $this->command->info('كلمة المرور: Test@123');

    }
}
