<?php

namespace Database\Seeders;

use App\Models\Center;
use App\Models\City;
use App\Models\State;
use Illuminate\Database\Seeder;

class LocationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Saudi Arabia's 13 administrative regions
        $statesData = [
            'الرياض' => [
                'الرياض' => ['الملز', 'العليا', 'النسيم', 'الملقا', 'الورود', 'السليمانية', 'العارض', 'الشفا', 'النهضة', 'الربوة'],
                'الخرج' => ['الخرج الشمالي', 'الخرج الجنوبي', 'السيح', 'الدلم'],
                'الدوادمي' => ['الدوادمي الشرقي', 'الدوادمي الغربي', 'البجادية'],
                'المجمعة' => ['المجمعة الشرقي', 'المجمعة الغربي', 'الغاط'],
                'القويعية' => ['القويعية الشرقي', 'القويعية الغربي'],
                'وادي الدواسر' => ['وادي الدواسر الشرقي', 'وادي الدواسر الغربي', 'السليل'],
                'الأفلاج' => ['ليلى', 'السليل', 'الأحساء'],
                'الزلفي' => ['الزلفي الشرقي', 'الزلفي الغربي'],
                'شقراء' => ['شقراء الشرقي', 'شقراء الغربي'],
                'حوطة بني تميم' => ['الحوطة', 'الحريق'],
                'عفيف' => ['عفيف الشرقي', 'عفيف الغربي'],
                'السليل' => ['السليل الشرقي', 'السليل الغربي'],
            ],
            'مكة المكرمة' => [
                'مكة المكرمة' => ['العزيزية', 'الشوقية', 'النور', 'الكعكية', 'الرصيفة', 'المسفلة', 'العوالي', 'التنعيم'],
                'جدة' => ['البلد', 'الروضة', 'الصفا', 'الفيصلية', 'النزهة', 'الحمراء', 'الشاطئ', 'أبحر الشمالية', 'أبحر الجنوبية'],
                'الطائف' => ['الطائف الشرقي', 'الطائف الغربي', 'الشفا', 'الهدا'],
                'المدينة المنورة' => ['المدينة', 'العوالي', 'قباء', 'العيون'],
                'ينبع' => ['ينبع البحر', 'ينبع النخل', 'ينبع الصناعية'],
                'رابغ' => ['رابغ الشرقي', 'رابغ الغربي'],
                'الجموم' => ['الجموم الشرقي', 'الجموم الغربي'],
                'خليص' => ['خليص الشرقي', 'خليص الغربي'],
                'الكامل' => ['الكامل الشرقي', 'الكامل الغربي'],
                'القنفذة' => ['القنفذة الشرقي', 'القنفذة الغربي'],
                'الليث' => ['الليث الشرقي', 'الليث الغربي'],
                'أضم' => ['أضم الشرقي', 'أضم الغربي'],
            ],
            'المنطقة الشرقية' => [
                'الدمام' => ['الفناتير', 'الشاطئ', 'الجلوية', 'الأثير', 'الفردوس', 'النور'],
                'الخبر' => ['العقربية', 'الثقبة', 'الكورنيش', 'دانة الخبر'],
                'الظهران' => ['الدوحة الشمالية', 'الدوحة الجنوبية', 'الكوثر'],
                'الأحساء' => ['الهفوف', 'المبرز', 'الجبيل', 'العيون'],
                'القطيف' => ['القطيف الشرقي', 'القطيف الغربي', 'صفوى', 'سيهات'],
                'الجبيل' => ['الجبيل الصناعية', 'الجبيل البلد'],
                'رأس تنورة' => ['رأس تنورة الشرقي', 'رأس تنورة الغربي'],
                'بقيق' => ['بقيق الشرقي', 'بقيق الغربي'],
                'النعيرية' => ['النعيرية الشرقي', 'النعيرية الغربي'],
                'خفجي' => ['خفجي الشرقي', 'خفجي الغربي'],
            ],
            'عسير' => [
                'أبها' => ['الشفا', 'الربوة', 'المنسك', 'الندوة', 'البساتين'],
                'خميس مشيط' => ['المطار', 'الشرفية', 'الموظفين', 'الرونة'],
                'النماص' => ['النماص الشرقي', 'النماص الغربي'],
                'محايل' => ['محايل الشرقي', 'محايل الغربي'],
                'بيشة' => ['بيشة الشرقي', 'بيشة الغربي'],
                'ظهران الجنوب' => ['ظهران الجنوب الشرقي', 'ظهران الجنوب الغربي'],
                'سراة عبيدة' => ['سراة عبيدة الشرقي', 'سراة عبيدة الغربي'],
                'أحد رفيدة' => ['أحد رفيدة الشرقي', 'أحد رفيدة الغربي'],
                'رجال ألمع' => ['رجال ألمع الشرقي', 'رجال ألمع الغربي'],
                'تنومة' => ['تنومة الشرقي', 'تنومة الغربي'],
            ],
            'المدينة المنورة' => [
                'المدينة المنورة' => ['المدينة', 'العوالي', 'قباء', 'العيون', 'الحرة الشرقية', 'الحرة الغربية'],
                'ينبع' => ['ينبع البحر', 'ينبع النخل', 'ينبع الصناعية'],
                'العلا' => ['العلا الشرقي', 'العلا الغربي'],
                'مهد الذهب' => ['مهد الذهب الشرقي', 'مهد الذهب الغربي'],
                'الحناكية' => ['الحناكية الشرقي', 'الحناكية الغربي'],
                'بدر' => ['بدر الشرقي', 'بدر الغربي'],
                'خيبر' => ['خيبر الشرقي', 'خيبر الغربي'],
                'الوجه' => ['الوجه الشرقي', 'الوجه الغربي'],
            ],
            'القصيم' => [
                'بريدة' => ['الصفراء', 'السالمية', 'الناصرية', 'الإسكان', 'البساتين'],
                'عنيزة' => ['عنيزة الشرقي', 'عنيزة الغربي', 'الزاهية'],
                'الرس' => ['الرس الشرقي', 'الرس الغربي'],
                'المذنب' => ['المذنب الشرقي', 'المذنب الغربي'],
                'البكيرية' => ['البكيرية الشرقي', 'البكيرية الغربي'],
                'الأسياح' => ['الأسياح الشرقي', 'الأسياح الغربي'],
                'النبهانية' => ['النبهانية الشرقي', 'النبهانية الغربي'],
                'عيون الجواء' => ['عيون الجواء الشرقي', 'عيون الجواء الغربي'],
                'الشماسية' => ['الشماسية الشرقي', 'الشماسية الغربي'],
                'رياض الخبراء' => ['رياض الخبراء الشرقي', 'رياض الخبراء الغربي'],
            ],
            'حائل' => [
                'حائل' => ['الصناعية', 'الزبيرة', 'الشملي', 'السليمانية', 'المطار'],
                'بقعاء' => ['بقعاء الشرقي', 'بقعاء الغربي'],
                'الغزالة' => ['الغزالة الشرقي', 'الغزالة الغربي'],
                'الشنان' => ['الشنان الشرقي', 'الشنان الغربي'],
                'السليمي' => ['السليمي الشرقي', 'السليمي الغربي'],
                'موقق' => ['موقق الشرقي', 'موقق الغربي'],
                'الحائط' => ['الحائط الشرقي', 'الحائط الغربي'],
                'سميراء' => ['سميراء الشرقي', 'سميراء الغربي'],
            ],
            'تبوك' => [
                'تبوك' => ['تبوك الشرقي', 'تبوك الغربي', 'الفيصلية', 'الروضة'],
                'الوجه' => ['الوجه الشرقي', 'الوجه الغربي'],
                'ضباء' => ['ضباء الشرقي', 'ضباء الغربي'],
                'تيماء' => ['تيماء الشرقي', 'تيماء الغربي'],
                'أملج' => ['أملج الشرقي', 'أملج الغربي'],
                'حقل' => ['حقل الشرقي', 'حقل الغربي'],
                'البدع' => ['البدع الشرقي', 'البدع الغربي'],
            ],
            'الحدود الشمالية' => [
                'عرعر' => ['عرعر الشرقي', 'عرعر الغربي', 'الصناعية', 'المطار'],
                'رفحاء' => ['رفحاء الشرقي', 'رفحاء الغربي'],
                'طريف' => ['طريف الشرقي', 'طريف الغربي'],
                'العويقيلة' => ['العويقيلة الشرقي', 'العويقيلة الغربي'],
            ],
            'جازان' => [
                'جازان' => ['جازان الشرقي', 'جازان الغربي', 'الروضة', 'الرونة'],
                'صبيا' => ['صبيا الشرقي', 'صبيا الغربي'],
                'أبو عريش' => ['أبو عريش الشرقي', 'أبو عريش الغربي'],
                'صامطة' => ['صامطة الشرقي', 'صامطة الغربي'],
                'أحد المسارحة' => ['أحد المسارحة الشرقي', 'أحد المسارحة الغربي'],
                'الحرث' => ['الحرث الشرقي', 'الحرث الغربي'],
                'ضمد' => ['ضمد الشرقي', 'ضمد الغربي'],
                'بيش' => ['بيش الشرقي', 'بيش الغربي'],
                'فرسان' => ['فرسان الشرقي', 'فرسان الغربي'],
                'العيدابي' => ['العيدابي الشرقي', 'العيدابي الغربي'],
            ],
            'نجران' => [
                'نجران' => ['نجران الشرقي', 'نجران الغربي', 'الفيصلية', 'الروضة'],
                'شرورة' => ['شرورة الشرقي', 'شرورة الغربي'],
                'حبونا' => ['حبونا الشرقي', 'حبونا الغربي'],
                'يدمة' => ['يدمة الشرقي', 'يدمة الغربي'],
                'خباش' => ['خباش الشرقي', 'خباش الغربي'],
                'بدر الجنوب' => ['بدر الجنوب الشرقي', 'بدر الجنوب الغربي'],
                'ثار' => ['ثار الشرقي', 'ثار الغربي'],
            ],
            'الباحة' => [
                'الباحة' => ['الباحة الشرقي', 'الباحة الغربي', 'الزاهر', 'الرونة'],
                'بلجرشي' => ['بلجرشي الشرقي', 'بلجرشي الغربي'],
                'المندق' => ['المندق الشرقي', 'المندق الغربي'],
                'العقيق' => ['العقيق الشرقي', 'العقيق الغربي'],
                'القرى' => ['القرى الشرقي', 'القرى الغربي'],
                'غامد الزناد' => ['غامد الزناد الشرقي', 'غامد الزناد الغربي'],
                'المخواة' => ['المخواة الشرقي', 'المخواة الغربي'],
                'بني حسن' => ['بني حسن الشرقي', 'بني حسن الغربي'],
                'قلوة' => ['قلوة الشرقي', 'قلوة الغربي'],
            ],
            'الجوف' => [
                'سكاكا' => ['سكاكا الشرقي', 'سكاكا الغربي', 'الصناعية', 'المطار'],
                'القريات' => ['القريات الشرقي', 'القريات الغربي'],
                'دومة الجندل' => ['دومة الجندل الشرقي', 'دومة الجندل الغربي'],
                'طبرجل' => ['طبرجل الشرقي', 'طبرجل الغربي'],
            ],
        ];

        foreach ($statesData as $stateName => $cities) {
            // Create state
            $state = State::create(['name' => $stateName]);

            foreach ($cities as $cityName => $centers) {
                // Create city
                $city = City::create([
                    'name' => $cityName,
                    'state_id' => $state->id,
                ]);

                foreach ($centers as $centerName) {
                    // Create center
                    Center::create([
                        'name' => $centerName,
                        'city_id' => $city->id,
                    ]);
                }
            }
        }

        $this->command->info('تم بذر بيانات الموقع بنجاح!');
        $this->command->info('تم إنشاء '.State::count().' منطقة');
        $this->command->info('تم إنشاء '.City::count().' مدينة');
        $this->command->info('تم إنشاء '.Center::count().' مركز');
    }
}
