<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('donor_portfolios', function (Blueprint $table) {
            $table->id();

            // Foreign key relationships
            $table->foreignId('org_id')->constrained('orgs')->onDelete('cascade');
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade');

            // Portfolio information
            $table->string('name');
            $table->decimal('balance', 15, 2)->default(0.00);

            $table->softDeletes();
            $table->timestamps();

            // Unique constraint: name must be unique within each org
            $table->unique(['org_id', 'name']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('donor_portfolios');
    }
};
