<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('org_user', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(\App\Models\Org::class)
                ->constrained()->cascadeOnDelete();
            $table->foreignIdFor(\App\Models\User::class)
                ->constrained()->cascadeOnDelete();
            $table->foreignIdFor(\App\Models\Department::class)
                ->nullable()->constrained()->nullOnDelete();
            $table->timestamps();

            $table->unique(['org_id', 'user_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('org_user');
    }
};
