<?php

namespace Database\Factories;

use App\Models\Org;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\\Workflows\\Models\\WorkflowTemplate>
 */
class WorkflowTemplateFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = \App\Workflows\Models\WorkflowTemplate::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'org_id' => Org::factory(),
            'name' => fake()->sentence(3),
            'subject_type' => fake()->randomElement(['order', 'invoice', 'customer']),
            'status' => 'draft',
            'version' => 1,
            'is_active' => true,
        ];
    }

    /**
     * Indicate that the workflow template is published.
     */
    public function published(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'published',
        ]);
    }
}
