<?php

namespace Database\Factories;

use App\Workflows\Models\WorkflowTemplate;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Workflows\Models\StepTemplate>
 */
class StepTemplateFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = \App\Workflows\Models\StepTemplate::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'workflow_template_id' => WorkflowTemplate::factory(),
            'position' => $this->faker->numberBetween(1, 10),
            'type' => $this->faker->randomElement(['approval', 'input', 'auto']),
            'system_key' => $this->faker->optional()->randomElement(['approval', 'review', 'launch']),
            'label' => $this->faker->words(2, true),
            'form_definition' => null,
            'validation' => null,
            'data_bindings' => null,
            'handler' => null,
            'is_locked' => false,
        ];
    }

    /**
     * Indicate that the step template is locked.
     */
    public function locked(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_locked' => true,
        ]);
    }

    /**
     * Indicate that the step template has a specific system key.
     */
    public function withSystemKey(string $systemKey): static
    {
        return $this->state(fn (array $attributes) => [
            'system_key' => $systemKey,
        ]);
    }
}
