<?php

namespace Database\Factories;

use App\Models\ProjectCharter;
use App\Models\ProjectCharterFile;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ProjectCharterFile>
 */
class ProjectCharterFileFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $fileNames = [
            'خطة المشروع التفصيلية',
            'دراسة الجدوى الاقتصادية',
            'تقرير التحليل الفني',
            'وثيقة المتطلبات',
            'خطة إدارة المخاطر',
            'دليل إجراءات العمل',
            'تقرير حالة المشروع',
            'خطة الاتصال',
            'وثيقة الموافقات',
            'تقرير المراجعة',
            'ميزانية المشروع التفصيلية',
            'جدولة الأنشطة الزمنية',
            'تتبع الموارد البشرية',
            'تحليل التكاليف',
            'مؤشرات الأداء الرئيسية',
            'خطة الشراء والتوريد',
            'تقرير الإنجاز المالي',
            'قائمة المهام والمسؤوليات',
            'عرض تقديمي للمشروع',
            'ملخص تنفيذي للمديرين',
            'نتائج المرحلة الأولى',
            'خطة التطوير المستقبلي',
            'عرض للجهات المانحة',
            'تقرير الإنجازات',
            'صورة موقع المشروع',
            'مخطط المشروع التوضيحي',
            'صور مراحل التنفيذ',
            'رسم بياني للهيكل التنظيمي',
            'صورة الفريق المشارك',
            'مخطط سير العمل',
        ];

        return [
            'name' => fake()->randomElement($fileNames),
            'description' => fake()->optional(0.7)->randomElement([
                'وثيقة مهمة للمشروع تحتوي على معلومات أساسية',
                'ملف يحتوي على بيانات تفصيلية حول المشروع',
                'مستند يوضح خطوات العمل والإجراءات المطلوبة',
                'تقرير شامل عن حالة المشروع والتقدم المحرز',
                'وثيقة معتمدة من الإدارة العليا',
                'ملف يحتوي على التوجيهات والسياسات',
                'مستند للمراجعة والموافقة من الجهات المختصة',
                'وثيقة تحتوي على البيانات الإحصائية والتحليلات',
            ]),
        ];
    }

    /**
     * Configure the model factory.
     */
    public function configure(): static
    {
        return $this->afterMaking(function (ProjectCharterFile $file) {
            if (! $file->org_id && $file->project_charter_id) {
                $charter = ProjectCharter::find($file->project_charter_id);
                if ($charter) {
                    $file->org_id = $charter->org_id;
                }
            }

            if (! $file->created_by) {
                // Get a user from the same org as the charter
                $org = $charter ?? ProjectCharter::find($file->project_charter_id);
                if ($org && $org->org) {
                    $orgUsers = $org->org->users()->get();
                    if ($orgUsers->isNotEmpty()) {
                        $file->created_by = $orgUsers->random()->id;
                    } else {
                        $file->created_by = $org->created_by;
                    }
                }
            }
        });
    }
}
