<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ProjectCharter>
 */
class ProjectCharterFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $startDate = fake()->dateTimeBetween('now', '+6 months');
        $endDate = fake()->dateTimeBetween($startDate, $startDate->format('Y-m-d').' +2 years');

        return [
            'name' => fake()->randomElement([
                'ميثاق مشروع البنية التحتية الأساسية',
                'ميثاق برنامج التدريب المتخصص',
                'ميثاق مبادرة الرعاية الصحية الشاملة',
                'ميثاق مشروع الأمن الغذائي',
                'ميثاق برنامج التعليم التقني',
                'ميثاق مشروع المرافق التعليمية',
                'ميثاق مبادرة الدعم النفسي',
                'ميثاق برنامج الحماية الاجتماعية',
                'ميثاق مشروع التحول الرقمي',
                'ميثاق مبادرة الصحة العامة',
            ]),
            'description' => fake()->paragraphs(3, true),
            'start_date' => $startDate,
            'expected_end_date' => $endDate,
            'total_cost' => fake()->randomFloat(2, 50000, 5000000),
            'initiative_project_id' => 1, // Use existing initiative project ID
            'initiative_id' => 1, // Use existing initiative ID
            'created_by' => 1, // Use existing user ID
        ];
    }
}
