<?php

namespace Database\Factories;

use App\Models\ProjectCharter;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ProjectCharterDeliverable>
 */
class ProjectCharterDeliverableFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $deliverableNames = [
            'تقرير دراسة الجدوى',
            'خطة التنفيذ التفصيلية',
            'نموذج أولي للمنتج',
            'تقرير التقييم الأولي',
            'دليل الإجراءات والسياسات',
            'تقرير الاختبار النهائي',
            'خطة التدريب والتطوير',
            'تقرير المراجعة الشاملة',
            'دليل المستخدم النهائي',
            'تقرير النتائج والتوصيات',
        ];

        $startDate = $this->faker->dateTimeBetween('-6 months', '+6 months');
        $endDate = $this->faker->dateTimeBetween($startDate, '+1 year');

        return [
            'project_charter_id' => ProjectCharter::factory(),
            'name' => $this->faker->randomElement($deliverableNames),
            'description' => $this->faker->paragraph(2),
            'delivery_date' => $endDate,
            'weight' => $this->faker->randomFloat(2, 5, 50), // 5% to 50% weight
            'cost' => $this->faker->randomFloat(2, 10000, 100000),
            'created_by' => User::factory(),
        ];
    }
}
