<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\InitiativeProject>
 */
class InitiativeProjectFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => fake()->randomElement([
                'مشروع تطوير البنية التحتية',
                'برنامج التدريب والتأهيل',
                'مبادرة الرعاية الصحية المتنقلة',
                'مشروع توزيع المواد الغذائية',
                'برنامج التعليم المهني',
                'مشروع بناء المراكز التعليمية',
                'مبادرة الرعاية النفسية',
                'برنامج دعم الأسر المحتاجة',
                'مشروع تطوير المهارات الرقمية',
                'مبادرة الصحة المجتمعية',
            ]),
            'weight' => fake()->randomFloat(2, 0.1, 100.0),
            'initiative_id' => 1, // Use existing initiative ID
            'created_by' => 1, // Use existing user ID
        ];
    }
}
