<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\DonorPortfolio>
 */
class DonorPortfolioFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => fake()->company().' Portfolio',
            'balance' => fake()->randomFloat(2, 0, 1000000), // Balance between 0 and 1,000,000
            'created_by' => \App\Models\User::factory(),
            'org_id' => function () {
                return \App\Models\Org::first()?->id ?? \App\Models\Org::create(['name' => 'Test Organization'])->id;
            },
        ];
    }
}
