<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\CompletionReport>
 */
class CompletionReportFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'project_charter_deliverable_id' => \App\Models\ProjectCharterDeliverable::factory(),
            'name' => $this->faker->sentence(3),
            'description' => $this->faker->paragraph(),
            'cost' => $this->faker->randomFloat(2, 100, 10000),
            'delivery_date' => $this->faker->dateTimeBetween('now', '+6 months'),
            'created_by' => \App\Models\User::factory(),
        ];
    }
}
