<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Association>
 */
class AssociationFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => fake()->company(),
            'license_number' => fake()->unique()->numerify('LIC-#######'),
            'license_expiration_date' => fake()->dateTimeBetween('+1 year', '+5 years'),
            'user_id' => \App\Models\User::factory(),
            'org_id' => \App\Models\Org::factory(),
            'city' => fake()->city(),
            'street' => fake()->streetName(),
            'district' => fake()->citySuffix(),
            'postal_code' => fake()->postcode(),
            'building_number' => fake()->buildingNumber(),
            'secondary_number' => fake()->optional()->numerify('##'),
            'lat' => fake()->latitude(),
            'lng' => fake()->longitude(),
            'iban' => fake()->iban(),
            'bank_name' => fake()->company().' Bank',
            'account_holder_name' => fake()->name(),
            'is_verified' => fake()->boolean(70), // 70% chance of being verified
            'is_locked' => fake()->boolean(10), // 10% chance of being locked
        ];
    }
}
