<?php

return [

    'models' => [
        \App\Models\Order::class => 'Order',
        \App\Models\ProjectCharter::class => 'Project Charter',
    ],

    /*
    |--------------------------------------------------------------------------
    | Required Steps Configuration
    |--------------------------------------------------------------------------
    |
    | Define which system_key steps are required for each subject type.
    | These steps must be present when publishing a workflow template.
    |
    */
    'required_steps' => [
        \App\Models\Order::class => [
            'study',
            'approval',
            'classification',
            'agreement',
            'launch',
        ],
        \App\Models\ProjectCharter::class => [
            'draft',
            'approval',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Step Template Options
    |--------------------------------------------------------------------------
    |
    | Define predefined step template configurations with validation,
    | data bindings, and form definitions.
    |
    */
    'step_templates' => [
        'finance_fields_and_bindings' => [
            'label' => 'Finance Fields and Bindings',
            'description' => 'Financial approval step with execution duration, company name, and offer price fields',
            'validation' => [
                'execution_duration' => ['required', 'integer', 'min:1'],
                'company_name' => ['required', 'string', 'max:255'],
                'offer_price' => ['required', 'numeric', 'min:0'],
            ],
            'data_bindings' => [
                'execution_duration' => ['target' => ['relation' => 'finance']],
                'company_name' => ['target' => ['relation' => 'finance']],
                'offer_price' => ['target' => ['relation' => 'finance']],
            ],
            'form_definition' => [
                [
                    'type' => 'text',
                    'name' => 'company_name',
                    'label' => 'Company Name',
                    'required' => true,
                    'placeholder' => 'Enter company name',
                ],
                [
                    'type' => 'number',
                    'name' => 'execution_duration',
                    'label' => 'Execution Duration (days)',
                    'required' => true,
                    'min' => 1,
                    'step' => 1,
                ],
                [
                    'type' => 'number',
                    'name' => 'offer_price',
                    'label' => 'Offer Price',
                    'required' => true,
                    'min' => 0,
                    'step' => 0.01,
                ],
            ],
            'suggested_system_keys' => ['launched'],
        ],
        'agreement_fields_and_bindings' => [
            'label' => 'Agreement Fields and Bindings',
            'description' => 'Agreement step with contract number, total contract value, and start date fields',
            'validation' => [
                'contract_number' => ['required', 'string', 'max:255'],
                'total_contract_value' => ['required', 'numeric', 'min:0'],
                'start_date' => ['required', 'date'],
            ],
            'data_bindings' => [
                'contract_number' => ['target' => ['relation' => 'agreement']],
                'total_contract_value' => ['target' => ['relation' => 'agreement']],
                'start_date' => ['target' => ['relation' => 'agreement']],
            ],
            'form_definition' => [
                [
                    'type' => 'text',
                    'name' => 'contract_number',
                    'label' => 'Contract Number',
                    'required' => true,
                    'placeholder' => 'Enter contract number',
                ],
                [
                    'type' => 'number',
                    'name' => 'total_contract_value',
                    'label' => 'Total Contract Value',
                    'required' => true,
                    'min' => 0,
                    'step' => 0.01,
                ],
                [
                    'type' => 'date',
                    'name' => 'start_date',
                    'label' => 'Start Date',
                    'required' => true,
                ],
            ],
            'suggested_system_keys' => ['agreement'],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Handler Whitelist
    |--------------------------------------------------------------------------
    |
    | Only handlers in this whitelist can be executed by the workflow engine.
    | This is a security measure to prevent arbitrary code execution.
    |
    */
    'handler_whitelist' => [
        // \App\Domain\Orders\Handlers\FinanceApprovalHandler::class,
        // Add more handlers here as needed
    ],
];
